<?php

/**
 * Copyright © 2020 Wyomind. All rights reserved.
 * See LICENSE.txt for license details.
 */
namespace Wyomind\OrderEraser\Ui\Component\Listing\Column;

/**
 * Render column block in the order grid
 */
class Delete extends \Magento\Ui\Component\Listing\Columns\Column
{
    public function __construct(\Wyomind\OrderEraser\Helper\Delegate $wyomind, \Magento\Framework\View\Element\UiComponent\ContextInterface $context, \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory, array $components = [], array $data = [])
    {
        $wyomind->constructor($this, $wyomind, __CLASS__);
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }
    /**
     * Prepare component configuration
     * @return void
     */
    public function prepare()
    {
        parent::prepare();
        if (false == $this->authorization->isAllowed('Wyomind_OrderEraser::delete')) {
            $this->_data['config']['componentDisabled'] = true;
        }
    }
    /**
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $html = "<a href='#' onclick='javascript:jQuery(this).parents(\"TD\").eq(0).off(\"click\");";
                $html .= "OrderEraser.delete(\"";
                $html .= $this->urlInterface->getUrl('ordereraser/orders/delete', array('selected' => $item['entity_id']));
                $html .= "\");";
                $html .= "'>Delete</a></span>";
                $item[$this->getData('name')] = $html;
            }
        }
        return $dataSource;
    }
}