<?php
/**
 * Copyright © 2020 Wyomind. All rights reserved.
 * See LICENSE.txt for license details.
 */

namespace Wyomind\OrderEraser\Block\Adminhtml\Order;

/**
 * Render the export button in order > view
 */
class View
{
    /**
     * @var \Magento\Framework\Authorization
     */
    private $authorization = null;

    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlInterface;

    /**
     * @param \Magento\Framework\Authorization $authorization
     * @param \Magento\Framework\UrlInterface $urlInterface
     */
    public function __construct(
        \Magento\Framework\Authorization $authorization,
        \Magento\Framework\UrlInterface $urlInterface
    )
    {
        $this->authorization = $authorization;
        $this->urlInterface = $urlInterface;
    }
    
    /**
     * Interceptor for getOrder
     * @param \Magento\Sales\Block\Adminhtml\Order\View $subject
     */
    public function beforeGetOrder(\Magento\Sales\Block\Adminhtml\Order\View $subject)
    {
        if ($this->authorization->isAllowed('Wyomind_OrderEraser::delete')) {
            $subject->addButton(
                'void_delete',
                array(
                    'label' => __('Delete'),
                    'onclick' => 'setLocation(\'' . $this->urlInterface->getUrl('ordereraser/orders/delete', array('selected' => $subject->getRequest()->getParam('order_id'))) . '\')'
                )
            );
        }
    }
}