<?php

/**
 * Copyright © 2018 Wyomind. All rights reserved.
 * See LICENSE.txt for license details.
 */
namespace Wyomind\Core\Block\Adminhtml\System\Config\Form\Field;

/**
 * Class Version
 */
class LicenseStatus extends \Magento\Config\Block\System\Config\Form\Field
{
    public function __construct(\Wyomind\Core\Helper\Delegate $wyomind, \Magento\Backend\Block\Template\Context $context, array $data = [])
    {
        $wyomind->constructor($this, $wyomind, __CLASS__);
        parent::__construct($context, $data);
    }
    /**
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return string
     */
    protected function _renderValue(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $extensionName = str_replace("_license_license_status", "", $element->getHtmlId());
        $extensionNameSpace = "Wyomind_" . str_replace(" ", "", $this->_configHelper->getStoreConfig($extensionName . "/license/extension_label"));
        $ak = $this->_configHelper->getStoreConfigUncrypted($extensionName . "/license/activation_key");
        $lc = $this->_configHelper->getStoreConfigUncrypted($extensionName . "/license/activation_code");
        $valid = $ak != "" && $lc != "";
        $status = "";
        if (!$valid) {
            if ($ak != "" && $lc == "") {
                $status = __("Invalidated");
            } else {
                $status = __("Pending");
                $ak = htmlentities("<activation key>");
            }
            $msg = "Please run bin/magento wyomind:license:activate " . $extensionNameSpace . " " . $ak;
            $rtn = "<div class='message message-danger'>" . $status . "";
            $rtn .= "<pre>{$msg}</pre></div>";
        } else {
            $rtn = "<div class='message message-success'>" . __("Registered") . "</div>";
        }
        $html = '<td class="value">';
        $html .= $rtn;
        $html .= '</td>';
        return $html;
    }
}