<?php

/**
 * Copyright © 2018 Wyomind. All rights reserved.
 * See LICENSE.txt for license details.
 */
namespace Wyomind\Core\Block\Adminhtml\System\Config\Form\Field;

/**
 * Class Version
 */
class ActivationKey extends \Magento\Config\Block\System\Config\Form\Field
{
    public function __construct(\Wyomind\Core\Helper\Delegate $wyomind, \Magento\Backend\Block\Template\Context $context, array $data = [])
    {
        $wyomind->constructor($this, $wyomind, __CLASS__);
        parent::__construct($context, $data);
    }
    /**
     * @param \Magento\Framework\Data\Form\Element\AbstractElement $element
     * @return string
     */
    protected function _renderValue(\Magento\Framework\Data\Form\Element\AbstractElement $element)
    {
        $ak = $this->_encryptor->decrypt($element->getValue());
        if ($ak == "") {
            $rtn = "<div class='message message-warning'>" . __("Pending") . "</div>";
        } else {
            $rtn = "<div class='message message-success'>" . $ak . "</div>";
        }
        $html = '<td class="value">';
        $html .= $rtn;
        $html .= '</td>';
        return $html;
    }
}