<?php

namespace Webkul\Rmasystem\Setup;

use Magento\Framework\App\State;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

/**
 * @codeCoverageIgnore
 */
class InstallData implements InstallDataInterface
{
    /**
     * {@inheritdoc}
     */
    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();

        $templateText = '{{template config_path="design/email/header_template"}}

<table>
    <tr class="email-intro">
        <td>
            <p class="greeting">{{trans "%customer_name," customer_name=$order.getCustomerName()}}</p>
            <p>
                {{trans "Thank you for your order from %store_name." store_name=$store.getFrontendName()}}
                {{trans "Once your package ships we will send you a tracking number."}}
                {{trans \'You can check the status of your order by <a href="%account_url">logging into your account</a>.\' account_url=$this.getUrl($store,\'customer/account/\',[_nosid:1]) |raw}}
            </p>
            <p>
                {{trans \'If you have questions about your order, you can email us at <a href="mailto:%store_email">%store_email</a>\' store_email=$store_email |raw}}{{depend store_phone}} {{trans \'or call us at <a href="tel:%store_phone">%store_phone</a>\' store_phone=$store_phone |raw}}{{/depend}}.
                {{depend store_hours}}
                {{trans \'Our hours are <span class="no-link">%store_hours</span>.\' store_hours=$store_hours |raw}}
                {{/depend}}
            </p>
        </td>
    </tr>
    <tr class="email-summary">
        <td>
            <h1>{{trans \'Your Order <span class="no-link">#%increment_id</span>\' increment_id=$order.increment_id |raw}}</h1>
            <p>{{trans \'Placed on <span class="no-link">%created_at</span>\' created_at=$order.getCreatedAtFormatted(2) |raw}}</p>
        </td>
    </tr>
    <tr class="email-information">
        <td>
            {{depend order.getEmailCustomerNote()}}
            <table class="message-info">
                <tr>
                    <td>
                        {{var order.getEmailCustomerNote()|escape|nl2br}}
                    </td>
                </tr>
            </table>
            {{/depend}}
            <table class="order-details">
                <tr>
                    <td class="address-details">
                        <h3>{{trans "Billing Info"}}</h3>
                        <p>{{var formattedBillingAddress|raw}}</p>
                    </td>
                    {{depend order.getIsNotVirtual()}}
                    <td class="address-details">
                        <h3>{{trans "Shipping Info"}}</h3>
                        <p>{{var formattedShippingAddress|raw}}</p>
                    </td>
                    {{/depend}}
                </tr>
                <tr>
                    <td class="method-info">
                        <h3>{{trans "Payment Method"}}</h3>
                        {{var payment_html|raw}}
                    </td>
                    {{depend order.getIsNotVirtual()}}
                    <td class="method-info">
                        <h3>{{trans "Shipping Method"}}</h3>
                        <p>{{var order.getShippingDescription()}}</p>
                        {{if shipping_msg}}
                        <p>{{var shipping_msg}}</p>
                        {{/if}}
                    </td>
                    {{/depend}}
                </tr>
            </table>
            {{layout handle="sales_email_order_items" order=$order area="frontend"}}
        </td>
    </tr>
    <tr class="rma-instructions">
        <td>
            {{block class=\'Webkul\\\\Rmasystem\\\\Block\\\\Rmainstructions\' area=\'frontend\' template=\'Webkul_Rmasystem::email/rma_instructions.phtml\'}}
        </td>
    </tr>
</table>

{{template config_path="design/email/footer_template"}}';

        $templateSubject = '{{trans "Your %store_name order confirmation" store_name=$store.getFrontendName()}}';
        $origTemplateVariables = '{"var formattedBillingAddress|raw":"Billing Address","var order.getEmailCustomerNote()":"Email Order Note","var order.increment_id":"Order Id","layout handle=\\"sales_email_order_items\\" order=$order area=\\"frontend\\"":"Order Items Grid","var payment_html|raw":"Payment Details","var formattedShippingAddress|raw":"Shipping Address","var order.getShippingDescription()":"Shipping Description","var shipping_msg":"Shipping message"}';

        $columns = ['template_code', 'template_text', 'template_type', 'template_subject', 'orig_template_code', 'orig_template_variables'];
        $data = [['[Webkul_Rmasystem] RMA New Order', $templateText, 2, $templateSubject, 'sales_email_order_template', $origTemplateVariables]];

        //Create Order email template with RMA block
        $setup->getConnection()
            ->insertArray($setup->getTable('email_template'), $columns, $data);

        //Set new order email template as default for orders
        $query = "SELECT `template_id` FROM `email_template` WHERE `template_code`='[Webkul_Rmasystem] RMA New Order'";
        $emailTemplateId = $setup->getConnection()->fetchOne($query);
        $data = [
            'scope' => 'default',
            'scope_id' => 0,
            'path' => 'sales_email/order/template',
            'value' => $emailTemplateId
        ];
        $setup->getConnection()
            ->insertOnDuplicate($setup->getTable('core_config_data'), $data, ['value']);

        $setup->endSetup();
    }
}
