<?php
namespace Webkul\Rmasystem\Model;

use Webkul\Rmasystem\Api\Data\RmaitemInterface;
use Magento\Framework\DataObject\IdentityInterface;

class Rmaitem extends \Magento\Framework\Model\AbstractModel implements RmaitemInterface, IdentityInterface
{

    /**#@+
     * Post's Statuses
     */
    const STATUS_ENABLED = 1;
    const STATUS_DISABLED = 0;
    /**#@-*/

    /**
     * CMS page cache tag
     */
    const CACHE_TAG = 'webkul_item';

    /**
     * @var string
     */
    protected $_cacheTag = 'webkul_item';

    /**
     * Prefix of model events names
     *
     * @var string
     */
    protected $_eventPrefix = 'webkul_item';

    /**
     * @var \Webkul\Rmasystem\Model\Allrma|null
     */
    protected $_rma = null;

    /**
     * @var \Magento\Sales\Model\Order\Item|null
     */
    protected $_orderItem = null;

    /**
     * @var \Magento\Sales\Model\Order\ItemFactory
     */
    protected $_orderItemFactory;

    protected function _construct()
    {
        $this->_init('Webkul\Rmasystem\Model\ResourceModel\Rmaitem');
    }

    /**
     * Initialize resource model
     *
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Api\ExtensionAttributesFactory $extensionFactory
     * @param \Magento\Framework\Api\AttributeValueFactory $customAttributeFactory
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param array $data
     * @param \Magento\Sales\Model\Order\ItemFactory $orderItemFactory
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Sales\Model\Order\ItemFactory $orderItemFactory,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->_orderItemFactory = $orderItemFactory;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }


    /**
     * Declare rma instance
     *
     * @param \Webkul\Rmasystem\Model\Allrma $rma
     * @return $this
     */
    public function setRma(\Webkul\Rmasystem\Model\Allrma $rma)
    {
        $this->_rma = $rma;
        return $this;
    }

    /**
     * Retrieve creditmemo instance
     *
     * @return \Magento\Sales\Model\Order\Creditmemo
     */
    public function getRma()
    {
        return $this->_rma;
    }


    /**
     * Prepare post's statuses.
     * Available event to customize statuses.
     *
     * @return array
     */
    public function getAvailableStatuses()
    {
        return [self::STATUS_ENABLED => __('Enabled'), self::STATUS_DISABLED => __('Disabled')];
    }
    /**
     * Return unique ID(s) for each object in system
     *
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * Get ID
     *
     * @return int|null
     */
    public function getId()
    {
        return $this->getData(self::ID);
    }
    /**
     * Get RMA ID
     *
     * @return int
     */
    public function getRmaId()
    {
        return $this->getData(self::RMA_ID);
    }
    /**
     * Get Item ID
     *
     * @return int
     */
    public function getItemId()
    {
        return $this->getData(self::ITEM_ID);
    }
    /**
     * Get Reason ID
     *
     * @return int
     */
    public function getReasonId()
    {
        return $this->getData(self::REASON_ID);
    }

    /**
     * Get Status
     *
     * @return decimal
     */
    public function getQty()
    {
        return $this->getData(self::QTY);
    }
    /**
     * Set ID
     *
     * @param int $id
     * @return \Webkul\Rmasystem\Api\Data\RmaitemInterface
     */
    public function setId($id)
    {
        return $this->setData(self::ID, $id);
    }
    /**
     * Set Item ID
     *
     * @return int
     */
    public function setItemId($itemId)
    {
        return $this->setData(self::ITEM_ID, $itemId);
    }
    /**
     * Set RMA ID
     *
     * @return string
     */
    public function setRmaId($rmaId)
    {
        return $this->setData(self::RMA_ID, $rmaId);
    }
    /**
     * Set Reason ID
     *
     * @return string
     */
    public function setReasonId($reasonId)
    {
        return $this->setData(self::REASON_ID, $reasonId);
    }
    /**
     * set return qty
     * @param price
     */
    public function setQty($qty)
    {
        return $this->setData(self::QTY, $qty);
    }

    /**
     * Declare order item instance
     *
     * @param \Magento\Sales\Model\Order\Item $item
     * @return $this
     */
    public function setOrderItem(\Magento\Sales\Model\Order\Item $item)
    {
        $this->_orderItem = $item;
        $this->setOrderItemId($item->getId());
        return $this;
    }

    /**
     * Retrieve order item instance
     *
     * @return \Magento\Sales\Model\Order\Item
     */
    public function getOrderItem()
    {
        if ($this->_orderItem === null) {
            if ($this->getRmaId()) {
                $orderItem = $this->getRma()->getOrder()->getItemById($this->getItemId());
            } else {
                $orderItem = $this->_orderItemFactory->create()->load($this->getItemId());
            }
            $this->_orderItem = $orderItem;
        }
        return $this->_orderItem;
    }
}
