<?php

namespace Webkul\Rmasystem\Model\Allrma\Pdf;

class Rma extends \Magento\Sales\Model\Order\Pdf\AbstractPdf
{
    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var \Webkul\Rmasystem\Api\Data\RmaitemInterfaceFactory
     */
    protected $rmaItemDataFactory;

    /**
     * @var Config
     */
    protected $_pdfConfig;

    /**
     * Totals models excluded from printing in totals
     * @var array
     */
    protected $toExcludeFromPdfDocumentTotals = [
        'MSP\CashOnDelivery\Model\Sales\Pdf\Amount',
        'MSP\CashOnDelivery\Model\Sales\Pdf\Tax',
        'Magento\Tax\Model\Sales\Pdf\Shipping'
    ];
    /**
     * @var \Webkul\Rmasystem\Helper\Data
     */
    private $helper;

    /**
     * @param \Magento\Payment\Helper\Data $paymentData
     * @param \Magento\Framework\Stdlib\StringUtils $string
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Framework\Filesystem $filesystem
     * @param \Magento\Sales\Model\Order\Pdf\Config $pdfConfig
     * @param \Magento\Sales\Model\Order\Pdf\Total\Factory $pdfTotalFactory
     * @param \Magento\Sales\Model\Order\Pdf\ItemsFactory $pdfItemsFactory
     * @param \Magento\Framework\Stdlib\DateTime\TimezoneInterface $localeDate
     * @param \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation
     * @param \Magento\Sales\Model\Order\Address\Renderer $addressRenderer
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\Locale\ResolverInterface $localeResolver
     * @param array $data
     *
     * @param \Webkul\Rmasystem\Helper\Data $helper
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     * @internal param \Magento\Framework\TranslateInterface $translate
     */
    public function __construct(
        \Magento\Payment\Helper\Data $paymentData,
        \Magento\Framework\Stdlib\StringUtils $string,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Framework\Filesystem $filesystem,
        \Magento\Sales\Model\Order\Pdf\Config $pdfConfig,
        \Magento\Sales\Model\Order\Pdf\Total\Factory $pdfTotalFactory,
        \Magento\Sales\Model\Order\Pdf\ItemsFactory $pdfItemsFactory,
        \Magento\Framework\Stdlib\DateTime\TimezoneInterface $localeDate,
        \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Magento\Sales\Model\Order\Address\Renderer $addressRenderer,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Framework\Locale\ResolverInterface $localeResolver,
        \Webkul\Rmasystem\Helper\Data $helper,
        array $data = []
    ) {
        $this->_storeManager = $storeManager;
        $this->_localeResolver = $localeResolver;
        $this->_pdfConfig = $pdfConfig;
        $this->helper = $helper;
        parent::__construct(
            $paymentData,
            $string,
            $scopeConfig,
            $filesystem,
            $pdfConfig,
            $pdfTotalFactory,
            $pdfItemsFactory,
            $localeDate,
            $inlineTranslation,
            $addressRenderer,
            $data
        );
    }

    /**
     * Draw table header for product items
     *
     * @param  \Zend_Pdf_Page $page
     * @return void
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function _drawHeader(\Zend_Pdf_Page $page)
    {
        $this->_setFontRegular($page, 10);
        $page->setFillColor(new \Zend_Pdf_Color_Rgb(0.93, 0.92, 0.92));
        $page->setLineColor(new \Zend_Pdf_Color_GrayScale(0.5));
        $page->setLineWidth(0.5);
        $page->drawRectangle(25, $this->y, 570, $this->y - 15);
        $this->y -= 10;
        $page->setFillColor(new \Zend_Pdf_Color_Rgb(0, 0, 0));

        //columns headers
        $lines[0][] = ['text' => __('Products'), 'feed' => 35];

        $lines[0][] = [
            'text' => $this->string->split(__('SKU'), 12, true, true),
            'feed' => 255,
            'align' => 'right',
        ];

        $lines[0][] = [
            'text' => $this->string->split(__('Total (ex)'), 12, true, true),
            'feed' => 330,
            'align' => 'right',
        ];

        $lines[0][] = [
            'text' => $this->string->split(__('Discount'), 12, true, true),
            'feed' => 380,
            'align' => 'right',
        ];

        $lines[0][] = [
            'text' => $this->string->split(__('Qty'), 12, true, true),
            'feed' => 445,
            'align' => 'right',
        ];

        $lines[0][] = [
            'text' => $this->string->split(__('Tax'), 12, true, true),
            'feed' => 495,
            'align' => 'right',
        ];

        $lines[0][] = [
            'text' => $this->string->split(__('Total (inc)'), 12, true, true),
            'feed' => 565,
            'align' => 'right',
        ];

        $lineBlock = ['lines' => $lines, 'height' => 5];

        $this->drawLineBlocks($page, [$lineBlock], ['table_header' => true]);
        $page->setFillColor(new \Zend_Pdf_Color_GrayScale(0));
        $this->y -= 20;
    }

    /**
     * Return PDF document
     *
     * @param  array $rmas
     * @return \Zend_Pdf
     */
    public function getPdf($rmas = [])
    {
        $this->_beforeGetPdf();
        $this->_initRenderer('rma');

        $pdf = new \Zend_Pdf();
        $this->_setPdf($pdf);
        $style = new \Zend_Pdf_Style();
        $this->_setFontBold($style, 10);

        foreach ($rmas as $rma) {
            if ($rma->getStoreId()) {
                $this->_localeResolver->emulate($rma->getStoreId());
                $this->_storeManager->setCurrentStore($rma->getStoreId());
            }
            $page = $this->newPage();
            $order = $rma->getOrder();

            /* Add image */
            $this->insertLogo($page, $rma->getStore());
            /* Add address */
            $this->insertAddress($page, $rma->getStore());
            /* Add head */
            $this->insertOrder(
                $page,
                $order,
     1
//                TODO: Aggiungere la voce Display Order ID in Header per RMA su Sales/PDF Print-outs
//                $this->_scopeConfig->isSetFlag(
//                    self::XML_PATH_SALES_PDF_CREDITMEMO_PUT_ORDER_ID,
//                    \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
//                    $order->getStoreId()
//                )
            );
            /* Add document text and number */
            $this->insertDocumentNumber($page, __('RMA # ') . $rma->getRmaId());
            /* Add table head */
            $this->_drawHeader($page);

            /* Add body */
            foreach ($rma->getAllItems() as $item) {
                if ($item->getOrderItem()->getParentItem()) {
                    continue;
                }
                /* Draw item */
                $this->_drawItem($item, $page, $order);
                $page = end($pdf->pages);
            }
            /* Add totals */
            $this->insertTotals($page, $rma);
        }
        $this->_afterGetPdf();
        if ($rma->getStoreId()) {
            $this->_localeResolver->revert();
        }
        return $pdf;
    }

    /**
     * Create new page and assign to PDF object
     *
     * @param  array $settings
     * @return \Zend_Pdf_Page
     */
    public function newPage(array $settings = [])
    {
        $page = parent::newPage($settings);
        if (!empty($settings['table_header'])) {
            $this->_drawHeader($page);
        }
        return $page;
    }

    /**
     * TODO: Spostare su modulo Drop che estende questo. Su questo non ha veramente senso fare queste eccezioni.
     * @return array|\Magento\Sales\Model\Order\Pdf\Total\DefaultTotal[]
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    protected function _getTotalsList()
    {
        $totals = $this->_pdfConfig->getTotals();
        usort($totals, [$this, '_sortTotalsList']);
        $totalModels = [];

        foreach ($totals as $totalInfo) {
            $class = empty($totalInfo['model']) ? null : $totalInfo['model'];
            if(in_array($class, $this->toExcludeFromPdfDocumentTotals)) {
                continue;
            }
            $totalModel = $this->_pdfTotalFactory->create($class);
            $totalModel->setData($totalInfo);
            $totalModels[] = $totalModel;
        }

        return $totalModels;
    }

    /**
     * Insert order to pdf page
     *
     * @param \Zend_Pdf_Page &$page
     * @param \Magento\Sales\Model\Order $obj
     * @param bool $putOrderId
     * @return void
     * @SuppressWarnings(PHPMD.CyclomaticComplexity)
     * @SuppressWarnings(PHPMD.NPathComplexity)
     * @SuppressWarnings(PHPMD.ExcessiveMethodLength)
     */
    protected function insertOrder(&$page, $obj, $putOrderId = true)
    {
        if ($obj instanceof \Magento\Sales\Model\Order) {
            $shipment = null;
            $order = $obj;
        } elseif ($obj instanceof \Magento\Sales\Model\Order\Shipment) {
            $shipment = $obj;
            $order = $shipment->getOrder();
        }

        $this->y = $this->y ? $this->y : 815;
        $top = $this->y;

        $page->setFillColor(new \Zend_Pdf_Color_GrayScale(0.45));
        $page->setLineColor(new \Zend_Pdf_Color_GrayScale(0.45));
        $page->drawRectangle(25, $top, 570, $top - 55);
        $page->setFillColor(new \Zend_Pdf_Color_GrayScale(1));
        $this->setDocHeaderCoordinates([25, $top, 570, $top - 55]);
        $this->_setFontRegular($page, 10);

        if ($putOrderId) {
            $page->drawText(__('Order # ') . $order->getRealOrderId(), 35, $top -= 30, 'UTF-8');
            $top +=15;
        }

        $top -=30;
        $page->drawText(
            __('Order Date: ') .
            $this->_localeDate->formatDate(
                $this->_localeDate->scopeDate(
                    $order->getStore(),
                    $order->getCreatedAt(),
                    true
                ),
                \IntlDateFormatter::MEDIUM,
                false
            ),
            35,
            $top,
            'UTF-8'
        );

        $top -= 10;
        $page->setFillColor(new \Zend_Pdf_Color_Rgb(0.93, 0.92, 0.92));
        $page->setLineColor(new \Zend_Pdf_Color_GrayScale(0.5));
        $page->setLineWidth(0.5);
        $page->drawRectangle(25, $top, 275, $top - 25);
        $page->drawRectangle(275, $top, 570, $top - 25);

        /* Calculate blocks info */

        /* Billing Address */
//        $billingAddress = $this->_formatAddress($this->addressRenderer->format($order->getBillingAddress(), 'pdf'));

        /* Payment */
//        $paymentInfo = $this->_paymentData->getInfoBlock($order->getPayment())->setIsSecureMode(true)->toPdf();
//        $paymentInfo = htmlspecialchars_decode($paymentInfo, ENT_QUOTES);
//        $payment = explode('{{pdf_row_separator}}', $paymentInfo);
//        foreach ($payment as $key => $value) {
//            if (strip_tags(trim($value)) == '') {
//                unset($payment[$key]);
//            }
//        }
//        reset($payment);

        $shippingAddress = $this->_formatAddress($this->addressRenderer->format($order->getShippingAddress(), 'pdf'));
//        $shippingMethod = $order->getShippingDescription();

        $page->setFillColor(new \Zend_Pdf_Color_GrayScale(0));
        $this->_setFontBold($page, 12);
        $page->drawText(__('Shipped to:'), 35, $top - 15, 'UTF-8');

//        if (!$order->getIsVirtual()) {
        $page->drawText(__('Return to:'), 285, $top - 15, 'UTF-8');
//        } else {
//            $page->drawText(__('Payment Method:'), 285, $top - 15, 'UTF-8');
//        }

        $rmaAddress = $this->_formatAddress($this->helper->getRmaFormattedAddress('pdf'));

        $addressesHeight = $this->_calcAddressHeight($rmaAddress);
        if (isset($shippingAddress)) {
            $addressesHeight = max($addressesHeight, $this->_calcAddressHeight($shippingAddress));
        }
//
        $page->setFillColor(new \Zend_Pdf_Color_GrayScale(1));
        $page->drawRectangle(25, $top - 25, 570, $top - 33 - $addressesHeight);
        $page->setFillColor(new \Zend_Pdf_Color_GrayScale(0));
        $this->_setFontRegular($page, 10);
        $this->y = $top - 40;
        $addressesStartY = $this->y;

        foreach ($shippingAddress as $value) {
            if ($value !== '') {
                $text = [];
                foreach ($this->string->split($value, 45, true, true) as $_value) {
                    $text[] = $_value;
                }
                foreach ($text as $part) {
                    $page->drawText(strip_tags(ltrim($part)), 35, $this->y, 'UTF-8');
                    $this->y -= 15;
                }
            }
        }

        $addressesEndY = $this->y;

//        if (!$order->getIsVirtual()) {
            $this->y = $addressesStartY;
            foreach ($rmaAddress as $value) {
                if ($value !== '') {
                    $text = [];
                    foreach ($this->string->split($value, 45, true, true) as $_value) {
                        $text[] = $_value;
                    }
                    foreach ($text as $part) {
                        $page->drawText(strip_tags(ltrim($part)), 285, $this->y, 'UTF-8');
                        $this->y -= 15;
                    }
                }
            }

            $addressesEndY = min($addressesEndY, $this->y);
            $this->y = $addressesEndY;

//            $page->setFillColor(new \Zend_Pdf_Color_Rgb(0.93, 0.92, 0.92));
//            $page->setLineWidth(0.5);
//            $page->drawRectangle(25, $this->y, 275, $this->y - 25);
//            $page->drawRectangle(275, $this->y, 570, $this->y - 25);
//
//            $this->y -= 15;
//            $this->_setFontBold($page, 12);
//            $page->setFillColor(new \Zend_Pdf_Color_GrayScale(0));
//            $page->drawText(__('Payment Method'), 35, $this->y, 'UTF-8');
//            $page->drawText(__('Shipping Method:'), 285, $this->y, 'UTF-8');
//
//            $this->y -= 10;
//            $page->setFillColor(new \Zend_Pdf_Color_GrayScale(1));
//
//            $this->_setFontRegular($page, 10);
//            $page->setFillColor(new \Zend_Pdf_Color_GrayScale(0));
//
//            $paymentLeft = 35;
//            $yPayments = $this->y - 15;
//        } else {
//            $yPayments = $addressesStartY;
//            $paymentLeft = 285;
//        }

//        foreach ($payment as $value) {
//            if (trim($value) != '') {
//                //Printing "Payment Method" lines
//                $value = preg_replace('/<br[^>]*>/i', "\n", $value);
//                foreach ($this->string->split($value, 45, true, true) as $_value) {
//                    $page->drawText(strip_tags(trim($_value)), $paymentLeft, $yPayments, 'UTF-8');
//                    $yPayments -= 15;
//                }
//            }
//        }

//        if ($order->getIsVirtual()) {
//            // replacement of Shipments-Payments rectangle block
//            $yPayments = min($addressesEndY, $yPayments);
//            $page->drawLine(25, $top - 25, 25, $yPayments);
//            $page->drawLine(570, $top - 25, 570, $yPayments);
//            $page->drawLine(25, $yPayments, 570, $yPayments);
//
//            $this->y = $yPayments - 15;
//        } else {
//            $topMargin = 15;
//            $methodStartY = $this->y;
//            $this->y -= 15;
//
//            foreach ($this->string->split($shippingMethod, 45, true, true) as $_value) {
//                $page->drawText(strip_tags(trim($_value)), 285, $this->y, 'UTF-8');
//                $this->y -= 15;
//            }
//
//            $yShipments = $this->y;
//            $totalShippingChargesText = "(" . __(
//                    'Total Shipping Charges'
//                ) . " " . $order->formatPriceTxt(
//                    $order->getShippingAmount()
//                ) . ")";
//
//            $page->drawText($totalShippingChargesText, 285, $yShipments - $topMargin, 'UTF-8');
//            $yShipments -= $topMargin + 10;
//
//            $tracks = [];
//            if ($shipment) {
//                $tracks = $shipment->getAllTracks();
//            }
//            if (count($tracks)) {
//                $page->setFillColor(new \Zend_Pdf_Color_Rgb(0.93, 0.92, 0.92));
//                $page->setLineWidth(0.5);
//                $page->drawRectangle(285, $yShipments, 510, $yShipments - 10);
//                $page->drawLine(400, $yShipments, 400, $yShipments - 10);
//                //$page->drawLine(510, $yShipments, 510, $yShipments - 10);
//
//                $this->_setFontRegular($page, 9);
//                $page->setFillColor(new \Zend_Pdf_Color_GrayScale(0));
//                //$page->drawText(__('Carrier'), 290, $yShipments - 7 , 'UTF-8');
//                $page->drawText(__('Title'), 290, $yShipments - 7, 'UTF-8');
//                $page->drawText(__('Number'), 410, $yShipments - 7, 'UTF-8');
//
//                $yShipments -= 20;
//                $this->_setFontRegular($page, 8);
//                foreach ($tracks as $track) {
//                    $maxTitleLen = 45;
//                    $endOfTitle = strlen($track->getTitle()) > $maxTitleLen ? '...' : '';
//                    $truncatedTitle = substr($track->getTitle(), 0, $maxTitleLen) . $endOfTitle;
//                    $page->drawText($truncatedTitle, 292, $yShipments, 'UTF-8');
//                    $page->drawText($track->getNumber(), 410, $yShipments, 'UTF-8');
//                    $yShipments -= $topMargin - 5;
//                }
//            } else {
//                $yShipments -= $topMargin - 5;
//            }
//
//            $currentY = min($yPayments, $yShipments);
//
//            // replacement of Shipments-Payments rectangle block
//            $page->drawLine(25, $methodStartY, 25, $currentY);
//            //left
//            $page->drawLine(25, $currentY, 570, $currentY);
//            //bottom
//            $page->drawLine(570, $currentY, 570, $methodStartY);
//            //right
//
//            $this->y = $currentY;
//            $this->y -= 15;
//        }
    }
}
