<?php
namespace Webkul\Rmasystem\Model;

use Webkul\Rmasystem\Api\Data\AllrmaInterface;
use Magento\Framework\DataObject\IdentityInterface;
use Magento\Sales\Model\EntityInterface;

/**
 * Rmasystem Allrma Model
 *
 */
class Allrma extends \Magento\Framework\Model\AbstractModel implements AllrmaInterface, IdentityInterface, EntityInterface
{
    /**
     * No route page id
     */
    const NOROUTE_ENTITY_ID = 'no-route';

    /**
     * Product's Statuses
     */
    const STATUS_PENDING = 0;
    const STATUS_CANCEL = 4;
    const STATUS_DECLINE = 3;
    const STATUS_SOLVE = 2;
    const STATUS_PROCESSING = 1;

    /**
     * Resolution Type
     */
    const RESOLUTION_TYPE_REFUND = 0;
    const RESOLUTION_TYPE_EXCHANGE = 1;
    const RESOLUTION_TYPE_CANCEL = 2;

    /**
     * Package Condition
     */
    const PACKAGE_CONDITION_OPEN = 0;
    const PACKAGE_CONDITION_PACKED = 1;

    /**
     * Customer entity
     *
     * @var Customer
     */
    protected $_customer;

    /**
     * @var \Magento\Sales\Model\Order
     */
    protected $_order;

    /**
     * @var \Magento\Sales\Model\OrderFactory
     */
    protected $_orderFactory;

    /**
     * @var CustomerFactory
     */
    protected $_customerFactory;

    /**
     * Marketplace Product cache tag
     */
    const CACHE_TAG = 'rmasystem_allrma';

    /**
     * @var string
     */
    protected $_cacheTag = 'rmasystem_allrma';

    /**
     * Prefix of model events names
     *
     * @var string
     */
    protected $_eventPrefix = 'rmasystem_allrma';
    /**
     * @var \Webkul\Rmasystem\Api\Data\RmaitemInterfaceFactory
     */
    private $rmaItemCollectionFactory;
    /**
     * @var \Magento\Sales\Model\Order\Item
     */
    private $item;

    protected function _construct()
    {
        $this->_init('Webkul\Rmasystem\Model\ResourceModel\Allrma');
    }

    /**
     * Initialize resource model
     *
     * @param \Magento\Framework\Model\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Customer\Model\CustomerFactory $customerFactory
     * @param \Magento\Sales\Model\OrderFactory $orderFactory
     * @param \Webkul\Rmasystem\Api\Data\RmaitemInterfaceFactory $rmaItemCollectionFactory
     * @param \Magento\Sales\Model\Order\Item $item
     * @param \Magento\Framework\Model\ResourceModel\AbstractResource|null $resource
     * @param \Magento\Framework\Data\Collection\AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\Model\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Customer\Model\CustomerFactory $customerFactory,
        \Magento\Sales\Model\OrderFactory $orderFactory,
        \Webkul\Rmasystem\Api\Data\RmaitemInterfaceFactory $rmaItemCollectionFactory,
        \Magento\Sales\Model\Order\Item $item,
        \Magento\Framework\Model\ResourceModel\AbstractResource $resource = null,
        \Magento\Framework\Data\Collection\AbstractDb $resourceCollection = null,
        array $data = []
    )
    {
        $this->_orderFactory = $orderFactory;
        $this->_customerFactory = $customerFactory;
        $this->rmaItemCollectionFactory = $rmaItemCollectionFactory;
        $this->item = $item;
        parent::__construct(
            $context,
            $registry,
            $resource,
            $resourceCollection,
            $data
        );
    }



    /**
     * Prepare product's statuses.
     * Available event marketplace_product_get_available_statuses to customize statuses.
     *
     * @return array
     */
    public function getAvailableStatuses()
    {
        return [
            self::STATUS_PENDING => __('Pending'),
            self::STATUS_PROCESSING => __('Processing'),
            self::STATUS_DECLINE => __('Decline'),
            self::STATUS_SOLVE => __('Solved'),
            self::STATUS_CANCEL => __('Cancelled')
        ];
    }

    /**
     * Get status label
     * @param $statusId
     * @return mixed
     */
    public function getStatusLabel($statusId)
    {
        return $this->getAvailableStatuses()[$statusId];
    }

    /**
     * Get identities
     *
     * @return array
     */
    public function getIdentities()
    {
        return [self::CACHE_TAG . '_' . $this->getId()];
    }

    /**
     * Get ID
     *
     * @return int
     */
    public function getId()
    {
        return parent::getData(self::RMA_ID);
    }
    /**
     * Get ID
     *
     * @return int
     */
    public function getOrderId()
    {
        return parent::getData(self::ORDER_ID);
    }

    /**
     * Declare order for creditmemo
     *
     * @param \Magento\Sales\Model\Order $order
     * @return $this
     */
    public function setOrder(\Magento\Sales\Model\Order $order)
    {
        $this->_order = $order;
        $this->setOrderId($order->getId())->setStoreId($order->getStoreId());
        return $this;
    }

    /**
     * @return mixed
     */
    public function getItemsCollection()
    {
        $collection = $this->rmaItemCollectionFactory->create()
                            ->getCollection()
                            ->addFieldToFilter('rma_id', $this->getId());
        if ($this->getId()) {
            foreach ($collection as $item) {
                $item->setRma($this);
            }
        }
        return $collection;
    }

    /**
     * Return rma items
     *
     * @return \Magento\Sales\Api\Data\CreditmemoItemInterface[]
     */
    public function getItems()
    {
        if ($this->getData('items') == null) {
            $this->setData(
                'items',
//                $this->getItemsCollection()->getItems()
                $this->getItemsCollection()
            );
        }
        return $this->getData('items');
    }

    /**
     * @return \Webkul\Rmasystem\Model\Rmaitem[]
     */
    public function getAllItems()
    {
        $items = [];
        foreach ($this->getItems() as $item) {
            $items[] = $item;
        }
        return $items;
    }

    /**
     * Retrieve the order the creditmemo for created for
     *
     * @return \Magento\Sales\Model\Order
     */
    public function getOrder()
    {
        if (!$this->_order instanceof \Magento\Sales\Model\Order) {
            $this->_order = $this->_orderFactory->create()->load($this->getOrderId());
        }
        return $this->_order;
    }

    /**
     * Get Increment ID
     *
     * @return string|null
     */
    public function getIncrementId()
    {
        return parent::getData(self::INCREMENT_ID);
    }
    /**
     * Get group name
     *
     * @return int
     */
    public function getGroup()
    {
        return parent::getData(self::GROUP);
    }
    /**
     * Get CUSTOMER ID
     *
     * @return int
     */
    public function getCustomerId()
    {
        return parent::getData(self::CUSTOMER_ID);
    }
    /**
     * Set group name
     *
     * @return int
     */
    public function setGroup($group)
    {
        return parent::setData(self::GROUP, $group);
    }

     /**
      * @return string
      */
    public function getCustomer()
    {
        if ($this->getCustomerId()) {
            $customerName = $this->_customerFactory->create()->load($this->getCustomerId)->getName();
        } else {
            $customerName = (string)__('Guest');
        }
        return $customerName;
    }

    /**
     * Get Package Condition
     *
     * @return string|null
     */
    public function getPackageCondition()
    {
        return parent::getData(self::PACKAGE_CONDITION);
    }

    /**
     * Get Package Condition
     *
     * @return array
     */
    public function getAvailablePackageCondition()
    {
        return [
            self::PACKAGE_CONDITION_OPEN => __('Open'),
            self::PACKAGE_CONDITION_PACKED => __('Packed')
        ];
    }

    /**
     * Get Package Condition
     *
     * @return string|null
     */
    public function getPackageConditionLabel($packageConditionId)
    {
        return $this->getAvailablePackageCondition()[$packageConditionId];
    }

    /**
     * Get Resolution Type
     *
     * @return string|null
     */
    public function getResolutionType()
    {
        return parent::getData(self::RESOLUTION_TYPE);
    }

    /**
     * Get Resolution Type
     *
     * @return array
     */
    public function getAvailableResolutionType()
    {
        return [
            self::RESOLUTION_TYPE_REFUND => __('Refund'),
            self::RESOLUTION_TYPE_EXCHANGE => __('Exchange'),
            self::RESOLUTION_TYPE_CANCEL => __('Cancel Item')
        ];
    }

    /**
     * Get Resolution Type
     *
     * @return string|null
     */
    public function getResolutionTypeLabel($resolutionTypeId)
    {
        return $this->getAvailableResolutionType()[$resolutionTypeId];
    }

     /**
      * Get Additional Info
      *
      * @return string|null
      */
    public function getAdditionalInfo()
    {
        return parent::getData(self::ADDITIONAL_INFO);
    }

    /**
     * Get Admin Delivery Status
     *
     * @return string|null
     */
    public function getAdminDeliveryStatus()
    {
        return parent::getData(self::ADMIN_DELIVERY_STATUS);
    }
     /**
      * Get Admin Consignment No
      *
      * @return string|null
      */
    public function getAdminConsignmentNo()
    {
        return parent::getData(self::ADMIN_CONSIGNMENT_NO);
    }
    /**
     * Get Images
     *
     * @return string|null
     */
    public function getImages()
    {
        return parent::getData(self::IMAGES);
    }

    /**
     * Get creation time
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return parent::getData(self::CREATED_AT);
    }

    /**
     * Get Shipping Label
     *
     * @return string|null
     */
    public function getShippingLabel()
    {
        return parent::getData(self::SHIPPING_LABEL);
    }
     /**
      * Get Guest Email
      *
      * @return string|null
      */
    public function getGuestEmail()
    {
        return parent::getData(self::GUEST_EMAIL);
    }

    /**
     * Get customer name
     *
     * @return string|null
     */
    public function getCustomerName()
    {
        return parent::getData(self::CUSTOMER_NAME);
    }

    /**
     * get rma status
     *
     * @return int|null
     */
    public function getStatus()
    {
        return parent::getData(self::STATUS);
    }

    /**
     * Get admin status
     *
     * @return int|null
     */
    public function getAdminStatus()
    {
        return parent::getData(self::ADMIN_STATUS);
    }

    /**
     * Get final rma status
     *
     * @return int|null
     */
    public function getFinalStatus()
    {
        return parent::getData(self::FINAL_STATUS);
    }

    /**
     * Get ID
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setId($id)
    {
        return $this->setData(self::RMA_ID, $id);
    }

    /**
     * Set Order ID Key
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setOrderId($orderId)
    {
        return $this->setData(self::ORDER_ID, $orderId);
    }

    /**
     * Set Increment ID
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setIncrementId($incrementId)
    {
        return $this->setData(self::INCREMENT_ID, $incrementId);
    }
    /**
     * Set CUSTOMER ID
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setCustomerId($customerId)
    {
        return $this->setData(self::CUSTOMER_ID, $customerId);
    }

    /**
     * Set Package Condition
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setPackageCondition($condition)
    {
        return $this->setData(self::PACKAGE_CONDITION, $condition);
    }

    /**
     * Set Resolution Type
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setResolutionType($resolutionType)
    {
        return $this->setData(self::RESOLUTION_TYPE, $resolutionType);
    }

     /**
      * Set Additional Info
      *
      * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
      */
    public function setAdditionalInfo($additionalInfo)
    {
        return $this->setData(self::ADDITIONAL_INFO, $additionalInfo);
    }

    /**
     * Set Admin Delivery Status
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setAdminDeliveryStatus($adminDeliveryStatus)
    {
        return $this->setData(self::ADMIN_DELIVERY_STATUS, $adminDeliveryStatus);
    }
     /**
      * Set Admin Consignment No
      *
      * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
      */
    public function setAdminConsignmentNo($adminConsignmentNo)
    {
        return $this->setData(self::ADMIN_CONSIGNMENT_NO, $adminConsignmentNo);
    }
    /**
     * Set Images
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setImages($images)
    {
        return $this->setData(self::IMAGES, $images);
    }

    /**
     * Set creation time
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setCreatedAt($createdAt)
    {
        return $this->setData(self::CREATED_AT, $createdAt);
    }

    /**
     * Set Shipping Label
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setShippingLabel($shippingLabel)
    {
        return $this->setData(self::SHIPPING_LABEL, $shippingLabel);
    }
     /**
      * Set Guest Email
      *
      * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
      */
    public function setGuestEmail($guestEmail)
    {
        return $this->setData(self::GUEST_EMAIL, $guestEmail);
    }

    /**
     * Set customer name
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setCustomerName($name)
    {
        return $this->setData(self::CUSTOMER_NAME, $name);
    }

    /**
     * Set rma status
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setStatus($status)
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * Set admin status
     *
     * @return \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setAdminStatus($status)
    {
        return $this->setData(self::ADMIN_STATUS, $status);
    }

    /**
     * Set final rma status
     *
     * @return  \Webkul\Rmasystem\Api\Data\AllrmaInterface
     */
    public function setFinalStatus($status)
    {
        return $this->setData(self::FINAL_STATUS, $status);
    }

    /**
     * Adding all orders methods
     *
     * ################
     *
     * base_subtotal
     * base_subtotal_canceled
     * base_subtotal_invoiced
     * base_subtotal_refunded
     * base_subtotal_incl_tax
     *
     * subtotal
     * subtotal_canceled
     * subtotal_invoiced
     * subtotal_refunded
     * subtotal_incl_tax
     *
     * base_total_canceled
     * base_total_invoiced
     * base_total_invoiced_cost
     * base_total_offline_refunded
     * base_total_online_refunded
     * base_total_paid
     * base_total_qty_ordered
     * base_total_refunded
     * base_total_due
     *
     * total_canceled
     * total_invoiced
     * total_offline_refunded
     * total_online_refunded
     * total_paid
     * total_qty_ordered
     * total_refunded
     * total_due
     *
     * base_grand_total
     * grand_total
     *
     * ########################
     *
     * base_shipping_amount
     * base_shipping_canceled
     * base_shipping_invoiced
     * base_shipping_refunded
     * base_shipping_tax_amount
     * base_shipping_tax_refunded
     * base_shipping_discount_amount
     * base_shipping_discount_tax_compensation_amnt
     * base_shipping_incl_tax
     *
     * shipping_amount
     * shipping_canceled
     * shipping_invoiced
     * shipping_refunded
     * shipping_tax_amount
     * shipping_tax_refunded
     * shipping_discount_amount
     * shipping_discount_tax_compensation_amount
     * shipping_incl_tax
     *
     * base_tax_amount
     * base_tax_canceled
     * base_tax_invoiced
     * base_tax_refunded
     *
     * tax_amount
     * tax_canceled
     * tax_invoiced
     * tax_refunded
     *
     * base_discount_amount
     * base_discount_canceled
     * base_discount_invoiced
     * base_discount_refunded
     * base_discount_tax_compensation_amount
     * base_discount_tax_compensation_invoiced
     * base_discount_tax_compensation_refunded
     *
     * discount_amount
     * discount_canceled
     * discount_invoiced
     * discount_refunded
     * discount_tax_compensation_amount
     * discount_tax_compensation_invoiced
     * discount_tax_compensation_refunded
     *
     * ###################
     *
     * base_to_global_rate
     * base_to_order_rate
     *
     * store_to_base_rate
     * store_to_order_rate
     *
     * base_currency_code
     * store_currency_code
     * global_currency_code
     *
     * ##################
     *
     * customer_is_guest
     *
     * store_id
     *
     * total_item_count
     *
     */

    public function getBaseSubtotal() {
        return $this->getOrder()->getBaseSubtotal();
    }
    public function getBaseSubtotalCanceled() {
        return $this->getOrder()->getBaseSubtotalCanceled();
    }
    public function getBaseSubtotalInvoiced() {
        return $this->getOrder()->getBaseSubtotalInvoiced();
    }
    public function getBaseSubtotalRefunded() {
        return $this->getOrder()->getBaseSubtotalRefunded();
    }
    public function getBaseSubtotalInclTax() {
        return $this->getOrder()->getBaseSubtotalInclTax();
    }
    public function getSubtotal() {
        return $this->getOrder()->getSubtotal();
    }
    public function getSubtotalCanceled() {
        return $this->getOrder()->getSubtotalCanceled();
    }
    public function getSubtotalInvoiced() {
        return $this->getOrder()->getSubtotalInvoiced();
    }
    public function getSubtotalRefunded() {
        return $this->getOrder()->getSubtotalRefunded();
    }
    public function getSubtotalInclTax() {
        return $this->getOrder()->getSubtotalInclTax();
    }
    /* ##################### */
    public function getBaseTotalCanceled() {
        return $this->getOrder()->getBaseTotalCanceled();
    }
    public function getBaseTotalInvoiced() {
        return $this->getOrder()->getBaseTotalInvoiced();
    }
    public function getBaseTotalInvoicedCost() {
        return $this->getOrder()->getBaseTotalInvoicedCost();
    }
    public function getBaseTotalOfflineRefunded() {
        return $this->getOrder()->getBaseTotalOfflineRefunded();
    }
    public function getBaseTotalOnlineRefunded() {
        return $this->getOrder()->getBaseTotalOnlineRefunded();
    }
    public function getBaseTotalPaid() {
        return $this->getOrder()->getBaseTotalPaid();
    }
    public function getBaseTotalQtyOrdered() {
        return $this->getOrder()->getBaseTotalQtyOrdered();
    }
    public function getBaseTotalRefunded() {
        return $this->getOrder()->getBaseTotalRefunded();
    }
    public function getBaseTotalDue() {
        return $this->getOrder()->getBaseTotalDue();
    }
    public function getTotalCanceled() {
        return $this->getOrder()->getTotalCanceled();
    }
    public function getTotalInvoiced() {
        return $this->getOrder()->getTotalInvoiced();
    }
    public function getTotalOfflineRefunded() {
        return $this->getOrder()->getTotalOfflineRefunded();
    }
    public function getTotalOnlineRefunded() {
        return $this->getOrder()->getTotalOnlineRefunded();
    }
    public function getTotalPaid() {
        return $this->getOrder()->getTotalPaid();
    }
    public function getTotalQtyOrdered() {
        return $this->getOrder()->getTotalQtyOrdered();
    }
    public function getTotalRefunded() {
        return $this->getOrder()->getTotalRefunded();
    }
    public function getTotalDue() {
        return $this->getOrder()->getTotalDue();
    }
    /* ##################### */
    public function getBaseGrandTotal() {
        return $this->getOrder()->getBaseGrandTotal();
    }
    //TODO: Spostare su modulo Drop che estende questo. Su questo non ha veramente senso fare queste eccezioni.
    public function getGrandTotal() {
        $calculatedGrandTotal = $this->getOrder()->getGrandTotal()
                - $this->getShippingInclTax()
                - $this->getOrder()->getMspCodAmount()
                - $this->getOrder()->getMspCodTaxAmount();
        return $calculatedGrandTotal;
    }
    /* ##################### */
    public function getBaseShippingAmount() {
        return $this->getOrder()->getBaseShippingAmount();
    }
    public function getBaseShippingCanceled() {
        return $this->getOrder()->getBaseShippingCanceled();
    }
    public function getBaseShippingInvoiced() {
        return $this->getOrder()->getBaseShippingInvoiced();
    }
    public function getBaseShippingRefunded() {
        return $this->getOrder()->getBaseShippingRefunded();
    }
    public function getBaseShippingTaxAmount() {
        return $this->getOrder()->getBaseShippingTaxAmount();
    }
    public function getBaseShippingTaxRefunded() {
        return $this->getOrder()->getBaseShippingTaxRefunded();
    }
    public function getBaseShippingDiscountAmount() {
        return $this->getOrder()->getBaseShippingDiscountAmount();
    }
    public function getBaseShippingDiscountTaxCompensationAmnt() {
        return $this->getOrder()->getBaseShippingDiscountTaxCompensationAmnt();
    }
    public function getBaseShippingInclTax() {
        return $this->getOrder()->getBaseShippingInclTax();
    }
    public function getShippingAmount() {
        return $this->getOrder()->getShippingAmount();
    }
    public function getShippingCanceled() {
        return $this->getOrder()->getShippingCanceled();
    }
    public function getShippingInvoiced() {
        return $this->getOrder()->getShippingInvoiced();
    }
    public function getShippingRefunded() {
        return $this->getOrder()->getShippingRefunded();
    }
    public function getShippingTaxAmount() {
        return $this->getOrder()->getShippingTaxAmount();
    }
    public function getShippingTaxRefunded() {
        return $this->getOrder()->getShippingTaxRefunded();
    }
    public function getShippingDiscountAmount() {
        return $this->getOrder()->getShippingDiscountAmount();
    }
    public function getShippingDiscountTaxCompensationAmount() {
        return $this->getOrder()->getShippingDiscountTaxCompensationAmount();
    }
    public function getShippingInclTax() {
        return $this->getOrder()->getShippingInclTax();
    }
    /* ##################### */
    public function getBaseTaxAmount() {
        return $this->getOrder()->getBaseTaxAmount();
    }
    public function getBaseTaxCanceled() {
        return $this->getOrder()->getBaseTaxCanceled();
    }
    public function getBaseTaxInvoiced() {
        return $this->getOrder()->getBaseTaxInvoiced();
    }
    public function getBaseTaxRefunded() {
        return $this->getOrder()->getBaseTaxRefunded();
    }
    public function getTaxAmount() {
        return $this->getOrder()->getTaxAmount();
    }
    public function getTaxCanceled() {
        return $this->getOrder()->getTaxCanceled();
    }
    public function getTaxInvoiced() {
        return $this->getOrder()->getTaxInvoiced();
    }
    public function getTaxRefunded() {
        return $this->getOrder()->getTaxRefunded();
    }
    /* ##################### */
    public function getBaseDiscountAmount() {
        return $this->getOrder()->getBaseDiscountAmount();
    }
    public function getBaseDiscountCanceled() {
        return $this->getOrder()->getBaseDiscountCanceled();
    }
    public function getBaseDiscountInvoiced() {
        return $this->getOrder()->getBaseDiscountInvoiced();
    }
    public function getBaseDiscountRefunded() {
        return $this->getOrder()->getBaseDiscountRefunded();
    }
    public function getBaseDiscountTaxCompensationAmount() {
        return $this->getOrder()->getBaseDiscountTaxCompensationAmount();
    }
    public function getBaseDiscountTaxCompensationInvoiced() {
        return $this->getOrder()->getBaseDiscountTaxCompensationInvoiced();
    }
    public function getBaseDiscountTaxCompensationRefunded() {
        return $this->getOrder()->getBaseDiscountTaxCompensationRefunded();
    }
    public function getDiscountAmount() {
        return $this->getOrder()->getDiscountAmount();
    }
    public function getDiscountCanceled() {
        return $this->getOrder()->getDiscountCanceled();
    }
    public function getDiscountInvoiced() {
        return $this->getOrder()->getDiscountInvoiced();
    }
    public function getDiscountRefunded() {
        return $this->getOrder()->getDiscountRefunded();
    }
    public function getDiscountTaxCompensationAmount() {
        return $this->getOrder()->getDiscountTaxCompensationAmount();
    }
    public function getDiscountTaxCompensationInvoiced() {
        return $this->getOrder()->getDiscountTaxCompensationInvoiced();
    }
    public function getDiscountTaxCompensationRefunded() {
        return $this->getOrder()->getDiscountTaxCompensationRefunded();
    }
    /* ##################### */
    public function getBaseToGlobalRate() {
        return $this->getOrder()->getBaseToGlobalRate();
    }
    public function getBaseToOrderRate() {
        return $this->getOrder()->getBaseToOrderRate();
    }
    public function getStoreToBaseRate() {
        return $this->getOrder()->getStoreToBaseRate();
    }
    public function getStoreToOrderRate() {
        return $this->getOrder()->getStoreToOrderRate();
    }
    public function getBaseCurrencyCode() {
        return $this->getOrder()->getBaseCurrencyCode();
    }
    public function getStoreCurrencyCode() {
        return $this->getOrder()->getStoreCurrencyCode();
    }
    public function getGlobalCurrencyCode() {
        return $this->getOrder()->getGlobalCurrencyCode();
    }
    public function getCustomerIsGuest() {
        return $this->getOrder()->getCustomerIsGuest();
    }
    public function getStoreId() {
        return $this->getOrder()->getStoreId();
    }
    public function getTotalItemCount() {
        return $this->getOrder()->getTotalItemCount();
    }


}
