<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Rmasystem
 * @author    Webkul
 * @copyright Copyright (c) 2010-2017 Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Rmasystem\Helper;

use Magento\Sales\Model\OrderRepository;

class Email extends \Magento\Framework\App\Helper\AbstractHelper
{
    /**
    * Recipient email config path
    */
    const XML_PATH_EMAIL_RECIPIENT = 'contact/email/recipient_email';
    /**
     * @var \Magento\Framework\Mail\Template\TransportBuilder
     */
    protected $_transportBuilder;

    /**
     * @var \Magento\Framework\Translate\Inline\StateInterface
     */
    protected $_inlineTranslation;

    /**
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;
    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $_customerSession;
    /**
     * url builder
     *
     * @var \Magento\Framework\UrlInterface
     */
    protected $urlBuilder;
    /**
     * @var \Magento\Framework\Escaper
     */
    protected $_escaper;
    /**
     * [$_rmaItemCollectionFactory description]
     * @var [type]
     */
    protected $_rmaItemCollectionFactory;

    /**
     * @var \Magento\Backend\Helper\Data
     */
    protected $adminHelper;

    /**
     * @var \Webkul\Rmasystem\Api\ReasonRepositoryInterface
     */
    protected $reasonRepository;

    /**
     * @var \Magento\Sales\Model\Order\ItemRepository
     */
    protected $orderItemRepository;

    /**
     * @var OrderRepository
     */
    protected $orderRepository;

    /**
     * @var \Webkul\Rmasystem\Helper\Data
     */
    protected $helper;
    /**
     * @var \Magento\Framework\App\Filesystem\DirectoryList
     */
    private $directoryList;
    /**
     * @var \Magento\Framework\Filesystem\Io\FileFactory
     */
    private $ioFileFactory;
    /**
     * @var \Webkul\Rmasystem\Model\Allrma\Pdf\Rma
     */
    private $pdfRma;

    /**
     * @param \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder
     * @param \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Customer\Model\Session $customerSession
     * @param \Magento\Framework\UrlInterface $urlBuilder
     * @param \Webkul\Rmasystem\Model\ResourceModel\Rmaitem\CollectionFactory $rmaItemCollectionFactory
     * @param \Magento\Framework\Escaper $escaper
     * @param OrderRepository $orderRepository
     * @param \Magento\Sales\Model\Order\ItemRepository $orderItemRepository
     * @param \Webkul\Rmasystem\Api\ReasonRepositoryInterface $reasonRepository
     * @param \Magento\Backend\Helper\Data $adminHelper
     * @param \Magento\Framework\App\Filesystem\DirectoryList $directoryList
     * @param Data $helper
     * @param \Webkul\Rmasystem\Model\Allrma\Pdf\Rma $pdfRma
     * @param \Magento\Framework\Filesystem\Io\FileFactory $ioFileFactory
     */
    public function __construct(
        \Magento\Framework\Mail\Template\TransportBuilder $transportBuilder,
        \Magento\Framework\Translate\Inline\StateInterface $inlineTranslation,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Store\Model\StoreManagerInterface $storeManager,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\UrlInterface $urlBuilder,
        \Webkul\Rmasystem\Model\ResourceModel\Rmaitem\CollectionFactory $rmaItemCollectionFactory,
        \Magento\Framework\Escaper $escaper,
        OrderRepository $orderRepository,
        \Magento\Sales\Model\Order\ItemRepository $orderItemRepository,
        \Webkul\Rmasystem\Api\ReasonRepositoryInterface $reasonRepository,
        \Magento\Backend\Helper\Data $adminHelper,
        \Magento\Framework\App\Filesystem\DirectoryList $directoryList,
        \Webkul\Rmasystem\Helper\Data $helper,
        \Webkul\Rmasystem\Model\Allrma\Pdf\Rma $pdfRma,
        \Magento\Framework\Filesystem\Io\FileFactory $ioFileFactory
    ) {
        $this->_transportBuilder = $transportBuilder;
        $this->_inlineTranslation = $inlineTranslation;
        $this->scopeConfig = $scopeConfig;
        $this->storeManager = $storeManager;
        $this->_customerSession = $customerSession;
        $this->_escaper = $escaper;
        $this->_rmaItemCollectionFactory = $rmaItemCollectionFactory;
        $this->reasonRepository = $reasonRepository;
        $this->orderRepository = $orderRepository;
        $this->orderItemRepository = $orderItemRepository;
        $this->urlBuilder = $urlBuilder;
        $this->adminHelper = $adminHelper;
        $this->helper = $helper;
        $this->directoryList = $directoryList;
        $this->pdfRma = $pdfRma;
        $this->ioFileFactory = $ioFileFactory;
    }

    /**
     * Post user question
     *
     * @return void
     * @throws \Exception
     */
    public function sendNewRmaEmail($post, $rma)
    {
        $this->_inlineTranslation->suspend();
        try {
            $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
            $store = $this->storeManager->getStore();
            $adminName = $this->scopeConfig->getValue("rmasystem/parameter/admin_name", $storeScope);
            $adminEmail = $this->scopeConfig->getValue("rmasystem/parameter/admin_email", $storeScope);
            $customerName = "";
            $customerEmail = "";
            if ($rma->getGroup() == "customer") {
                $customerName = $this->_customerSession->getCustomer()->getName();
                $customerEmail = $this->_customerSession->getCustomer()->getEmail();
            } else {
                $order = $this->orderRepository->get($rma->getOrderId());
                $customerName = $order->getCustomerFirstname()." ".$order->getCustomerLastname();
                $customerEmail = $order->getCustomerEmail();
            }
            $templateVariable = [];
            $templateVariable["rma_id"] = $rma->getIncrementId()."-".$rma->getRmaId();
            $templateVariable["order_id"] = $rma->getIncrementId();
            $templateVariable["resolution_type"] = $this->helper->getResolutionTypeLabel($rma->getResolutionType());
            $templateVariable["package_condition"] = $this->helper->getPackageConditionLabel($rma->getPackageCondition());
            $templateVariable["additional_info"] = nl2br(strip_tags($rma->getAdditionalInfo()));
            //RMA items listing
            $rmaItems = $this->_rmaItemCollectionFactory->create()->addFieldToFilter("rma_id", $rma->getRmaId());

            $count = 1;
            $rmaItemHtml = "";
            foreach ($rmaItems as $item) {
                $mageItem = $this->orderItemRepository->get($item->getItemId());
                $rmaItemHtml .= "<tbody ";
                if ($count % 2 != 0) {
                    $rmaItemHtml .= "bgcolor='#F6F6F6'";
                }
                $rmaItemHtml .= ">
                <tr>
                    <td><strong>".$mageItem->getName()."</strong></td>
                    <td>".$mageItem->getSku()."</td>
                    <td>".$item->getQty()."</td>
                    <td><span>".__($this->reasonRepository->getById($item->getReasonId())->getReason()) . "</span></td>
                </tr>";
                $count++;
            }
            $templateVariable["items"] = $rmaItemHtml;
            $templateVariable["receiver_name"] = $customerName;
            $templateVariable["title"] = __("Thanks for your RMA request, will contact you soon.");
            $templateVariable["rma_link_label"] = __("To view the RMA:");
            $templateVariable["rma_link"] = $this->storeManager->getStore()->getUrl('rmasystem/viewrma/index', ['id' => $rma->getRmaId()]).'';
            $sender = [
                'name' => $adminName,
                'email' => $adminEmail,
            ];

            $transport = $this->_transportBuilder
                ->setTemplateIdentifier('new_rma_email_template')
                ->setTemplateOptions(
                    [
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $this->storeManager->getStore()->getStoreId(),
                    ]
                )
                ->setTemplateVars($templateVariable)
                ->setFrom($sender)
                ->addTo($customerEmail, $customerName)
                ->getTransport();

            $copyTo = $this->scopeConfig->getValue("rmasystem/parameter/rma_copy_to", $storeScope);
            if(!empty($copyTo)) {
                $copyMethod = $this->scopeConfig->getValue("rmasystem/parameter/rma_copy_method", $storeScope);

                if($copyMethod == 'copy') {
                    $this->sendNewRmaEmailSeparate($post, $rma, $templateVariable);
                } elseif($copyMethod == 'bcc') {
                    $receiverEmails = explode(',', $this->scopeConfig->getValue("rmasystem/parameter/rma_copy_to", $storeScope));
                    $transport->addBcc($receiverEmails);
                }
            }

//            echo quoted_printable_decode($transport->getMessage()->getBody()->getContent());
//            die();

            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_inlineTranslation->resume();
        }
    }

    public function sendNewRmaEmailSeparate($post, $rma, $templateVariable)
    {
        $this->_inlineTranslation->suspend();
        try {
            $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
            $store = $this->storeManager->getStore();
            $receiverEmails = explode(',', $this->scopeConfig->getValue("rmasystem/parameter/rma_copy_to", $storeScope));
            $sender = [
                'name' => $this->scopeConfig->getValue('trans_email/ident_general/name', \Magento\Store\Model\ScopeInterface::SCOPE_STORE),
                'email' => $this->scopeConfig->getValue('trans_email/ident_general/email', \Magento\Store\Model\ScopeInterface::SCOPE_STORE),
            ];

            $transport = $this->_transportBuilder
                ->setTemplateIdentifier('new_rma_email_template')
                ->setTemplateOptions([
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $this->storeManager->getStore()->getStoreId(),
                ])
                ->setTemplateVars($templateVariable)
                ->setFrom($sender)
                ->addTo($receiverEmails, $receiverEmails)
                ->getTransport();

//            echo quoted_printable_decode($transport->getMessage()->getBody()->getContent());
//            die();

            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_inlineTranslation->resume();
        }
    }

    public function cancelRmaEmail($rma)
    {
        $this->_inlineTranslation->suspend();
        try {
            $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
            $adminName = $this->scopeConfig->getValue("rmasystem/parameter/admin_name", $storeScope);
            $adminEmail = $this->scopeConfig->getValue("rmasystem/parameter/admin_email", $storeScope);
            $customerName = "";
            $customerEmail = "";
            $order = $this->orderRepository->get($rma->getOrderId());
            $customerName = $order->getCustomerFirstname()." ".$order->getCustomerLastname();
            $customerEmail = $order->getCustomerEmail();
            $templateVariable = [];
            $templateVariable["rma_id"] = $rma->getIncrementId()."-".$rma->getRmaId();
            $templateVariable["order_id"] = $rma->getIncrementId();
            $templateVariable["status"] = __("Cancelled");
            //For Customer
            $templateVariable["receiver_name"] = $customerName;
            $templateVariable["title"] = __("You have just cancelled your RMA request, Details are as follows.");
            $sender = [
                'name' => $adminName,
                'email' => $adminEmail,
            ];
            $transport = $this->_transportBuilder
                ->setTemplateIdentifier('cancel_rma_email_template')
                ->setTemplateOptions(
                    [
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $this->storeManager->getStore()->getStoreId(),
                    ]
                )
                ->setTemplateVars($templateVariable)
                ->setFrom($sender)
                ->addTo($customerEmail, $customerName)
                ->getTransport();

            $transport->sendMessage();
            $this->_inlineTranslation->resume();

            // For Admin
            $templateVariable["receiver_name"] = $adminName;
            $templateVariable["title"] = __("One RMA request, Details are as follows");
            $sender = [
                'name' => $customerName,
                'email' => $customerEmail,
            ];
            $transport = $this->_transportBuilder
                ->setTemplateIdentifier('cancel_rma_email_template')
                ->setTemplateOptions(
                    [
                        'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                        'store' => $this->storeManager->getStore()->getStoreId(),
                    ]
                )
                ->setTemplateVars($templateVariable)
                ->setFrom($sender)
                ->addTo($adminEmail, $adminName)
                ->getTransport();

//                echo quoted_printable_decode($transport->getMessage()->getBody()->getContent());
//                die();

            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_inlineTranslation->resume();
        }
    }
    public function newMessageEmail($post, $rma, $area, $fileName)
    {
        $filePath = $this->helper->getConversationDir($rma->getId());
        $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
        $adminName = $this->scopeConfig->getValue("rmasystem/parameter/admin_name", $storeScope);
        $adminEmail = $this->scopeConfig->getValue("rmasystem/parameter/admin_email", $storeScope);
        $order = $this->orderRepository->get($rma->getOrderId());
        $customerName = $order->getCustomerFirstname()." ".$order->getCustomerLastname();
        $customerEmail = $order->getCustomerEmail();
        $templateVariable = [];
        $templateVariable["rma_id"] = $rma->getIncrementId()."-".$post["rma_id"];
        $templateVariable["order_id"] = $rma->getIncrementId();
        $templateVariable["message"] = nl2br(strip_tags($post["message"]));
        $templateVariable["receiver_name"] = $customerName;
        if ($area == "front") {
            $templateVariable["title"] = __("Your Message has been successfully saved for following RMA.");
        } else {
            $templateVariable["title"] = __("New Message has been appended to following RMA.");
        }
        $sender = [
            'name' => $adminName,
            'email' => $adminEmail,
        ];

        try {
            $transport = $this->_transportBuilder
                ->setTemplateIdentifier('message_email_template')
                ->setTemplateOptions(
                    [
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $this->storeManager->getStore()->getStoreId(),
                    ]
                )
                ->setTemplateVars($templateVariable)
                ->setFrom($sender)
                ->addTo($customerEmail, $customerName)
                ->addAttachment(($filePath.$fileName),$fileName)
                ->getTransport();

            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_inlineTranslation->resume();
        }

        $templateVariable["receiver_name"] = $adminName;
        if ($area == "admin") {
            $templateVariable["title"] = __("Your Message has been successfully saved for following RMA.");
        } else {
            $templateVariable["title"] = __("New Message has been appended to following RMA.");
        }
        // For Admin
        $templateVariable["receiver_name"] = $adminName;
        $templateVariable["title"] = __("RMA Updated details are as follows:");
        $sender = [
            'name' => $customerName,
            'email' => $customerEmail,
        ];
        try {
            $transport = $this->_transportBuilder
                ->setTemplateIdentifier('message_email_template')
                ->setTemplateOptions(
                    [
                    'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                    'store' => $this->storeManager->getStore()->getStoreId(),
                    ]
                )
                ->setTemplateVars($templateVariable)
                ->setFrom($sender)
                ->addTo($adminEmail, $adminName)
                ->addAttachment(($filePath.$fileName),$fileName)
                ->getTransport();

//                echo quoted_printable_decode($transport->getMessage()->getBody()->getContent());
//                die();

            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_inlineTranslation->resume();
        }

    }
    public function updateRmaEmail($post, $rma, $statusFlag, $deliveryFlag, $type, $fileName)
    {
        $filePath = $this->helper->getConversationDir($rma->getId());
        $temp_path = '';
        if (isset($attachment['tmp_name'])) {
            $temp_path = $attachment['tmp_name'];
        }
        $this->_inlineTranslation->suspend();
        $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
        $adminName = $this->scopeConfig->getValue("rmasystem/parameter/admin_name", $storeScope);
        $adminEmail = $this->scopeConfig->getValue("rmasystem/parameter/admin_email", $storeScope);

        $customerName = "";
        $customerEmail = "";
        if ($rma->getGroup() == "customer") {
            $customerName = $this->_customerSession->getCustomer()->getName();
            $customerEmail = $this->_customerSession->getCustomer()->getEmail();
        } else {
            $order = $this->orderRepository->get($rma->getOrderId());
            $customerName = $order->getCustomerFirstname()." ".$order->getCustomerLastname();
            $customerEmail = $order->getCustomerEmail();
        }
        $statusData = "";
        if ($statusFlag == true && $deliveryFlag == true) {
            $rmaStatus = "";
            $rmaStatus = $this->helper->getAdminStatusTitle($rma->getAdminStatus(), $rma->getResolutionType());
        } else {
            if ($statusFlag == true) {
                $rmaStatus = "";
                $rmaStatus = $this->helper->getAdminStatusTitle($rma->getAdminStatus(), $rma->getResolutionType());
                $statusData .= ">
                    <tr>
                        <th>".__('Status')."</th>
                    </tr>
                    <tr>
                        <td>" . $rmaStatus . "</td>
                    </tr>";
            }
        }
        $templateVariable = [];
        $templateVariable["rma_id"] = $rma->getIncrementId()."-".$post["rma_id"];
        $templateVariable["order_id"] = $rma->getIncrementId();
        $templateVariable["message"] = nl2br(strip_tags($post["message"]));
        $templateVariable["status_data"] = $statusData;
        $templateVariable["receiver_name"] = $customerName;
        $templateVariable["title"] = __("Your RMA Updated successfully details are as follows.");

        $sender = [
            'name' => $adminName,
            'email' => $adminEmail,
        ];

        if ($type == 'front') {
            try {
                $transport = $this->_transportBuilder
                    ->setTemplateIdentifier('update_rma_email_template')
                    ->setTemplateOptions(
                        [
                        'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                        'store' => $this->storeManager->getStore()->getStoreId(),
                        ]
                    )
                    ->setTemplateVars($templateVariable)
                    ->setFrom($sender)
                    ->addTo($customerEmail, $customerName)
                    ->addAttachment(($filePath.$fileName),$fileName)
                    ->getTransport();

//                echo quoted_printable_decode($transport->getMessage()->getBody()->getContent());
//                die();

                $transport->sendMessage();
                $this->_inlineTranslation->resume();
            } catch (\Exception $e) {
                $this->_inlineTranslation->resume();
            }
        }

        if ($type == 'admin') {
            // For Admin
            $templateVariable["receiver_name"] = $adminName;
            $templateVariable["title"] = __('RMA Updated details are as follows:');
            try {
                $transport = $this->_transportBuilder
                    ->setTemplateIdentifier('update_rma_email_template')
                    ->setTemplateOptions(
                        [
                        'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                        'store' => $this->storeManager->getStore()->getStoreId(),
                        ]
                    )
                    ->setTemplateVars($templateVariable)
                    ->setFrom($sender)
                    ->addTo($sender['email'], $sender['name'])
                    ->addAttachment(($filePath.$fileName),$fileName)
                    ->getTransport();

//                echo quoted_printable_decode($transport->getMessage()->getBody()->getContent());
//                die();

                $transport->sendMessage();
                $this->_inlineTranslation->resume();
            } catch (\Exception $e) {
                $this->_inlineTranslation->resume();
            }
        }
    }

    public function sendApprovedRmaEmail($post, $rma)
    {
        $this->_inlineTranslation->suspend();
        try {
            $storeScope = \Magento\Store\Model\ScopeInterface::SCOPE_STORE;
            $store = $this->storeManager->getStore();
            $adminName = $this->scopeConfig->getValue("rmasystem/parameter/admin_name", $storeScope);
            $adminEmail = $this->scopeConfig->getValue("rmasystem/parameter/admin_email", $storeScope);
            $order = $this->orderRepository->get($rma->getOrderId());
            $customerName = $order->getCustomerFirstname()." ".$order->getCustomerLastname();
            $customerEmail = $order->getCustomerEmail();
            $templateVariable = [];
            $templateVariable["rma_id"] = $rma->getIncrementId()."-".$rma->getRmaId();
            $templateVariable["order_id"] = $rma->getIncrementId();
            $templateVariable["resolution_type"] = $this->helper->getResolutionTypeLabel($rma->getResolutionType());
            $templateVariable["additional_info"] = nl2br(strip_tags($rma->getAdditionalInfo()));
            //RMA items listing
            $rmaItems = $this->_rmaItemCollectionFactory->create()->addFieldToFilter("rma_id", $rma->getRmaId());

            $count = 1;
            $rmaItemHtml = "";
            foreach ($rmaItems as $item) {
                $mageItem = $this->orderItemRepository->get($item->getItemId());
                $rmaItemHtml .= "<tbody ";
                if ($count % 2 != 0) {
                    $rmaItemHtml .= "bgcolor='#F6F6F6'";
                }
                $rmaItemHtml .= ">
                <tr>
                    <td><strong>".$mageItem->getName()."</strong></td>
                    <td>" . $mageItem->getSku() . "</td>
                    <td>" . $item->getQty() . "</td>
                    <td><span>" . __($this->reasonRepository->getById($item->getReasonId())->getReason()) ."</span></td>
                </tr>";
                $count++;
            }
            $templateVariable["items"] = $rmaItemHtml;
            $templateVariable["receiver_name"] = $customerName;
            $templateVariable["title"] = __("Your RMA was approved.");
            $templateVariable["rma_link_label"] = __("To view the RMA:");
            $templateVariable["rma_link"] =$this->storeManager->getStore()->getUrl('rmasystem/viewrma/index', ['id' => $rma->getRmaId()]).'';
            $sender = [
                'name' => $adminName,
                'email' => $adminEmail,
            ];

            $attachmentFilePath = $this->directoryList->getPath('var') . '/rma-' . $rma->getRmaId() . '.pdf';
            if(!file_exists($attachmentFilePath)) {
                $ioFile = $this->ioFileFactory->create();
                if($ioFile->open(array('path' => $this->directoryList->getPath('var')))) {
                    $ioFile->write('rma-' . $rma->getRmaId() . '.pdf', $this->pdfRma->getPdf([$rma])->render(), 0666);
                }
            }

            if(!empty($copyTo)) {
                $copyMethod = $this->scopeConfig->getValue("rmasystem/parameter/rma_copy_method", $storeScope);
                if($copyMethod == 'copy') {
                    $this->sendNewRmaEmailSeparate($post, $rma, $templateVariable);
                } elseif($copyMethod == 'bcc') {
                    $receiverEmails = explode(',', $this->scopeConfig->getValue("rmasystem/parameter/rma_copy_to", $storeScope));
                    $transport->addBcc($receiverEmails);
                }
            }

            $transport = $this->_transportBuilder
                ->setTemplateIdentifier('approved_rma_email_template')
                ->setTemplateOptions(
                    [
                        'area' => \Magento\Framework\App\Area::AREA_FRONTEND,
                        'store' => $this->storeManager->getStore()->getStoreId(),
                    ]
                )
                ->setTemplateVars($templateVariable)
                ->setFrom($sender)
                ->addTo($customerEmail, $customerName)
                ->addAttachment(
                    $this->directoryList->getPath('var') . '/rma-' . $rma->getRmaId() . '.pdf',
                    'rma-' . $rma->getRmaId() . '.pdf'
                )->getTransport();

//                echo quoted_printable_decode($transport->getMessage()->getBody()->getContent());
//                die();

            $transport->sendMessage();
            $this->_inlineTranslation->resume();
        } catch (\Exception $e) {
            $this->_inlineTranslation->resume();
        }
    }
}
