<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Webkul\Rmasystem\Controller\Viewrma;

use Magento\Framework\App\ResponseInterface;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Sales\Api\CreditmemoRepositoryInterface;

class DownloadPdf extends \Magento\Framework\App\Action\Action
{
    /**
     * Authorization level of a basic admin session
     *
     * @see _isAllowed()
     */
//    const ADMIN_RESOURCE = 'Webkul_Rmasystem::update';

    /**
     * @var \Magento\Framework\App\Response\Http\FileFactory
     */
    protected $_fileFactory;

    /**
     * @var \Magento\Backend\Model\View\Result\ForwardFactory
     */
    protected $resultForwardFactory;

    /**
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\App\Response\Http\FileFactory $fileFactory
     * @param \Magento\Backend\Model\View\Result\ForwardFactory $resultForwardFactory
     * @param CreditmemoRepositoryInterface $creditmemoRepository
     */
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Backend\Model\View\Result\ForwardFactory $resultForwardFactory
    ) {
        $this->_fileFactory = $fileFactory;
        $this->resultForwardFactory = $resultForwardFactory;
        parent::__construct($context);
    }

    /**
     * @return \Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        /** @var \Magento\Framework\View\Result\Page $resultPage */
        $id = $this->getRequest()->getParam('id');
        if (!$id) {
            $resultForward = $this->resultForwardFactory->create();
            $resultForward->forward('noroute');
            return $resultForward;
        }

        $model = $this->_objectManager->get('Webkul\Rmasystem\Model\Allrma')->load($id);
        if (!$model) {
            $resultForward = $this->resultForwardFactory->create();
            $resultForward->forward('noroute');
            return $resultForward;
        }

        $pdf = $this->_objectManager->create(
            \Webkul\Rmasystem\Model\Allrma\Pdf\Rma::class
        )->getPdf(
            [$model]
        );
        $date = $this->_objectManager->get(
            \Magento\Framework\Stdlib\DateTime\DateTime::class
        )->date('Y-m-d_H-i-s');
        return $this->_fileFactory->create(
            'rma-' . $date . '.pdf',
            $pdf->render(),
            DirectoryList::VAR_DIR,
            'application/pdf'
        );
    }

//    /**
//     * @var PageFactory
//     */
//    protected $resultPageFactory;
//
//    /**
//     * @param Context $context
//     * @param PageFactory $resultPageFactory
//     */
//    public function __construct(
//        Context $context,
//        \Magento\Framework\View\Result\PageFactory $resultPageFactory
//    ) {
//        $this->resultPageFactory = $resultPageFactory;
//        parent::__construct($context);
//    }
//
//    /**
//     * @return \Magento\Framework\View\Result\Page
//     */
//    public function execute()
//    {
//        /** @var \Magento\Framework\View\Result\Page $resultPage */
//        $resultPage = $this->resultPageFactory->create();
//        $customerId = $this->_objectManager->create('Magento\Customer\Model\Session')->getCustomerId();
//        $id = $this->getRequest()->getParam('id');
//        $model = $this->_objectManager->get('Webkul\Rmasystem\Model\Allrma')->load($id);
//        $resultPage->getConfig()->getTitle()->set(__('RMA DETAILS'));
//        if ($model->getCustomerId() != $customerId) {
//            $this->_redirect->getRefererUrl();
//            $this->messageManager->addError(
//                __('Sorry You Are Not Authorised to print this RMA request')
//            );
//        }
//        return $resultPage;
//    }
}
