<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_Rmasystem
 * @author    Webkul
 * @copyright Copyright (c) 2010-2017 Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\Rmasystem\Controller\Adminhtml\Allrma;

use Magento\Backend\App\Action;
use Magento\TestFramework\ErrorLog\Logger;
use Magento\Framework\App\Filesystem\DirectoryList;
use Webkul\Rmasystem\Api\AllRmaRepositoryInterface;
use Magento\Sales\Api\OrderRepositoryInterface;

class Delete extends \Magento\Backend\App\Action
{
    protected $_filename;

    protected $_emailHelper;

    /**
     * @var \Webkul\Rmasystem\Api\Data\ConversationInterfaceFactory
     */
    protected $conversationDataFactory;

    /**
     * @var \Webkul\Rmasystem\Api\ConversationRepositoryInterface
     */
    protected $conversationRepository;
    /**
     * @var AllRmaRepositoryInterface
     */
    protected $rmaRepository;

    protected $rmaCreditMemo;

    protected $_orderItem;
    /**
     * @var \Webkul\Rmasystem\Helper\Data
     */
    protected $helper;

    /**
     * @var OrderRepositoryInterface
     */
    protected $_orderRepository;

    private $_messages = [
        1 => 'Your Return request has been approved',
        5 => 'Your Return request has been declined.',
        6 => 'Your Return request has been solved.'
    ];

    /**
     *
     * @param Action\Context $context
     * @param \Webkul\Rmasystem\Api\Data\ConversationInterfaceFactory $conversationDataFactory
     * @param \Webkul\Rmasystem\Api\ConversationRepositoryInterface $conversationRepository
     * @param \Magento\MediaStorage\Model\File\UploaderFactory $fileUploaderFactory
     * @param \Webkul\Rmasystem\Controller\Adminhtml\Order\CreditMemo $rmaCreditMemo
     * @param OrderRepositoryInterface $orderRepository
     * @param AllRmaRepositoryInterface $rmaRepository
     * @param \Webkul\Rmasystem\Helper\Data $helper
     * @param \Webkul\Rmasystem\Helper\Email $emailHelper
     * @param \Magento\Sales\Model\Order\Item $orderItem
     */
    public function __construct(
        Action\Context $context,
        \Webkul\Rmasystem\Api\Data\ConversationInterfaceFactory $conversationDataFactory,
        \Webkul\Rmasystem\Api\ConversationRepositoryInterface $conversationRepository,
        \Magento\MediaStorage\Model\File\UploaderFactory $fileUploaderFactory,
        \Webkul\Rmasystem\Controller\Adminhtml\Order\CreditMemo $rmaCreditMemo,
        OrderRepositoryInterface $orderRepository,
        AllRmaRepositoryInterface $rmaRepository,
        \Webkul\Rmasystem\Helper\Data $helper,
        \Webkul\Rmasystem\Helper\Email $emailHelper,
        \Magento\Sales\Model\Order\Item $orderItem
    ) {
        $this->_emailHelper = $emailHelper;
        $this->helper = $helper;
        $this->conversationDataFactory = $conversationDataFactory;
        $this->conversationRepository = $conversationRepository;
        $this->_fileUploaderFactory = $fileUploaderFactory;
        $this->rmaRepository = $rmaRepository;
        $this->rmaCreditMemo = $rmaCreditMemo;
        $this->_orderRepository = $orderRepository;
        $this->_orderItem = $orderItem;
        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     */
    protected function _isAllowed()
    {
        return $this->_authorization->isAllowed('Webkul_Rmasystem::update');
    }

    /**
     * Save action
     *
     * @return \Magento\Framework\Controller\ResultInterface
     */
    public function execute()
    {
        $resultRedirect = $this->resultRedirectFactory->create();
        $rmaId = $this->getRequest()->getParam('id');
        if(empty($rmaId)) {
            $this->messageManager->addError('Cannot delete because rma_id is empty.');
            return $resultRedirect->setPath("*/allrma/index");
        }

        $rma = $this->rmaRepository->getById($rmaId);
        if(!$rma) {
            $this->messageManager->addError('Cannot find rma with id: ' . $rmaId);
            return $resultRedirect->setPath("*/allrma/index");
        }

        try {
            $this->rmaRepository->delete($rma);
            $this->messageManager->addSuccess(__('RMA Successfully Deleted'));
            return $resultRedirect->setPath("*/allrma/index");
        } catch (\Exception $e) {
            $this->messageManager->addError($result['msg']);
            $this->logger->info(': ' . $e->getMessage());
            return $resultRedirect->setPath("*/allrma/edit", ["id" => $rma->getId()]);
        }
    }

}
