<?php
/**
 * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/
 * @author     Mediotype                     https://www.mediotype.com/
 */

namespace Vertex\Tax\Model\Api\Utility;

use Vertex\Mapper\MapperFactory;
use Vertex\Tax\Model\Api\ConfigBuilder;
use Vertex\Utility\VersionDeterminer;

/**
 * Retrieve a mapper based on Magento configuration
 */
class MapperFactoryProxy
{
    /** @var ConfigBuilder */
    private $configBuilder;

    /** @var MapperFactory */
    private $factory;

    /** @var VersionDeterminer */
    private $versionDeterminer;

    /**
     * @param MapperFactory $factory
     * @param VersionDeterminer $versionDeterminer
     * @param ConfigBuilder $configBuilder
     */
    public function __construct(
        MapperFactory $factory,
        VersionDeterminer $versionDeterminer,
        ConfigBuilder $configBuilder
    ) {
        $this->factory = $factory;
        $this->versionDeterminer = $versionDeterminer;
        $this->configBuilder = $configBuilder;
    }

    /**
     * Retrieve a mapper instance given a MapperInterface
     *
     * @param string $mapperInterface Mapper Interface to create
     * @param string|null $storeCode Store ID to use for configuration
     * @return mixed
     * @throws \Vertex\Exception\ConfigurationException
     */
    public function getForClass($mapperInterface, $storeCode = null)
    {
        $config = $this->configBuilder
            ->setStoreCode($storeCode)
            ->build();

        $version = $this->versionDeterminer->execute($config->getTaxAreaLookupWsdl());

        return $this->factory->getForClass($mapperInterface, $version);
    }
}
