<?php
/**
 * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/
 * @author     Mediotype                     https://www.mediotype.com/
 */

namespace Vertex\Tax\Model\Api\Service;

use Vertex\Services\Invoice;
use Vertex\Services\InvoiceFactory as SdkInvoiceFactory;
use Vertex\Tax\Model\Api\ConfigBuilder;

/**
 * Build an {@see Invoice} service class
 */
class InvoiceBuilder
{
    /** @var ConfigBuilder */
    private $configBuilder;

    /** @var SdkInvoiceFactory */
    private $sdkFactory;

    /** @var string Store ID */
    private $storeCode;

    /**
     * @param ConfigBuilder $configBuilder
     * @param SdkInvoiceFactory $sdkFactory
     */
    public function __construct(
        ConfigBuilder $configBuilder,
        SdkInvoiceFactory $sdkFactory
    ) {
        $this->configBuilder = $configBuilder;
        $this->sdkFactory = $sdkFactory;
    }

    /**
     * Create an Invoice Service
     *
     * @return Invoice
     */
    public function build()
    {
        $config = $this->configBuilder->setStoreCode($this->storeCode)
            ->build();

        return $this->sdkFactory->create(
            [
                'configuration' => $config,
            ]
        );
    }

    /**
     * Set the Store Code
     *
     * @param string|null $storeCode
     * @return InvoiceBuilder
     */
    public function setStoreCode($storeCode)
    {
        $this->storeCode = $storeCode;
        return $this;
    }
}
