<?php
/**
 * @copyright  Vertex. All rights reserved.  https://www.vertexinc.com/
 * @author     Mediotype                     https://www.mediotype.com/
 */

namespace Vertex\Tax\Model\Calculation\VertexCalculator;

use Magento\Framework\Registry;
use Vertex\Tax\Model\Calculation\VertexCalculator;

/**
 * Class for retrieving errors that occured during the Vertex Tax Calculation process
 */
class ErrorRetriever
{
    /** @var Registry */
    private $registry;

    /**
     * @param Registry $registry
     */
    public function __construct(Registry $registry)
    {
        $this->registry = $registry;
    }

    /**
     * Retrieve the last registered calculation error.
     *
     * @return string|boolean Returns error message, or false if no error is set.
     */
    public function getError()
    {
        return $this->registry->registry(VertexCalculator::VERTEX_CALCULATION_ERROR) ?: false;
    }
}
