<?php
/**
 * @category    Tun2U
 * @package     Tun2U_AutoRelated
 * @author      Tun2U Team <info@tun2u.com>
 * @copyright   Copyright (c) 2019 Tun2U (https://www.tun2u.com)
 * @license     https://opensource.org/licenses/gpl-3.0.html  GNU General Public License (GPL 3.0)
 */

namespace Tun2U\AutoRelated\Model;

use Magento\Framework\Model\AbstractModel;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Registry;
use Magento\CatalogInventory\Helper\Stock;
use Magento\Catalog\Model\Product\Visibility;
use \Magento\Catalog\Model\Product\Attribute\Source\Status;

class Collection extends AbstractModel
{

    /**
    * @var \Magento\Core\Model\Factory\Helper
    */
    protected $_helper;

    /**
    * @var \Magento\Framework\Registry
    */
    protected $_registry;

    /**
    * @var Stock
    */
    protected $_stockHelper;


    public function __construct(
        Registry $registry,
        ObjectManagerInterface $helperFactory,
        Stock $stockHelper
    ) {
        $this->_registry = $registry;
        $this->_helper = $helperFactory;
        $this->_stockHelper = $stockHelper;
    }


    /**
     * Related Products automatically calculation:
     *      Visibility Catalog/Search
     *      Status Enabled
     *      Inventory In Stock
     *      Same Category
     *      Price Greater
     *      Order by Price Descendant
     *      Limit by Admin Configuration
     * @param bool $limit
     * @return bool|mixed
     */
    public function getRelatedProducts($limit = false)
    {
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $products = $this->getData('products');

        if (!$products) {
            $product = $this->_registry->registry('product');
            if ($category = $this->_registry->registry('category')) {
            } elseif ($product) {
                $ids = $product->getCategoryIds();
                if (!empty($ids)) {
                    $category = $objectManager->get('Magento\Catalog\Model\Category')->load($ids[0]);
                }
            }

            if ($category) {
                if ($limit === false) {
                    $limit = $this->_helper->get('Tun2U\AutoRelated\Helper\Data')->getLimit();
                }

                $_price = $product->getFinalPrice();

                $products = $objectManager->get('Magento\Catalog\Model\ResourceModel\Product\Collection')
                    ->setVisibility(Visibility::VISIBILITY_BOTH)
                    ->addAttributeToFilter('status', Status::STATUS_ENABLED)
                    ->addCategoryFilter($category)
                    ->addPriceDataFieldFilter('%s >= %s', ['min_price', $_price])
                    ->addFinalPrice()
                    ->addAttributeToSelect(['name', 'image'])
                    ->addAttributeToSelect(['*'])
                    ->setPageSize($limit);

                if ($product) {
                    $products->addAttributeToFilter('entity_id', ['neq' => $this->_registry->registry('product')->getId()]);
                }

                $this->_stockHelper->addInStockFilterToCollection($products);
                $products->getSelect()->order('price_index.min_price DESC');

                $this->setData('related_products', $products);
            } else {
                return false;
            }
        }

        return $products;
    }
}
