<?php

namespace Teslaamazing\ProductDraggable\Block\Adminhtml\Category\Tab;

use Teslaamazing\ProductDraggable\Block\Adminhtml\Category\Tab\Product\Grid\Renderer\Image;
use Teslaamazing\ProductDraggable\Block\Adminhtml\Category\Tab\Product\Grid\Renderer\Position;

class Product extends \Magento\Catalog\Block\Adminhtml\Category\Tab\Product
{
    /**
     * Set collection object adding product thumbnail
     *
     * @param \Magento\Framework\Data\Collection $collection
     * @return void
     */
    public function setCollection($collection)
    {
        $collection->addAttributeToSelect('thumbnail');
        $this->_collection = $collection;
    }

    /**
     * add column image with a custom renderer and after column entity_id
     * add draggable column after position
     * @return Product
     * @throws \Exception
     */
    protected function _prepareColumns()
    {
        parent::_prepareColumns();

        $this->removeColumn('position');
        $this->addColumn(
            'position',
            [
                'header' => __('Position'),
                'type' => 'number',
                'index' => 'position',
                'renderer' => Position::class,
                'editable' => !$this->getCategory()->getProductsReadonly()
            ]
        );

        $this->addColumnAfter(
            'image',
            [
                'header' => __('Thumbnail'),
                'index' => 'image',
                'renderer' => Image::class,
                'filter' => false,
                'sortable' => false,
                'column_css_class' => 'data-grid-thumbnail-cell'
            ],
            'entity_id'
        );

        $this->addColumnAfter(
            'dragging',
            [
                'type' => 'draggable-handle',
                'inline_css' => 'draggable-handle',
                'column_css_class' => 'data-grid-draggable-row-cell',
                'filter' => false
            ],
            'position'
        );

        $this->sortColumnsByOrder();
        $this->setDefaultSort('position');
        $this->setDefaultDir('asc');

        return $this;
    }

}
