<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Scommerce\GoogleUniversalAnalytics\Model\Source;

/**
 * @api
 * @since 100.0.2
 */
class WebsiteStores implements \Magento\Framework\Option\ArrayInterface
{
    /**
     * @var array
     */
    protected $_options;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $storeManager;

    /**
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        \Magento\Store\Model\StoreManagerInterface $storeManager
    )
    {
        $this->storeManager = $storeManager;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        if (!$this->_options) {
            /** @var $stores \Magento\Store\Model\StoreManagerInterface */
            $stores = $this->storeManager->getStores();
            foreach($stores as $store) {
                $website = $this->storeManager->getWebsite($store->getWebsiteId());
                $this->_options[] = ['value' => $store->getStoreId(), 'label' => $website->getName() . ' - ' . $store->getName() . ' (' . $store->getCode() . ')'];
            }
        }
        return $this->_options;
    }
}
