<?php
namespace Niks\LayeredNavigation\Plugin;

use Magento\Swatches\Model\Plugin\FilterRenderer as CoreRenderer;
use Magento\Framework\App\ObjectManager;
use Magento\Store\Model\StoreManagerInterface;

/**
 * Class FilterRenderer
 */
class FilterRenderer extends CoreRenderer
{
    /**
     * Path to RenderLayered Block
     *
     * @var string
     */
    protected $block = \Niks\LayeredNavigation\Block\LayeredNavigation\RenderLayered::class;

    /**
     * @var \Niks\LayeredNavigation\Helper\Data
     */
    private $helper;

    /**
     * FilterRenderer constructor.
     * @param \Magento\Framework\View\LayoutInterface $layout
     * @param \Magento\Swatches\Helper\Data $swatchHelper
     * @param \Niks\LayeredNavigation\Helper\Data $helper
     */
    public function __construct(
        \Magento\Framework\View\LayoutInterface $layout,
        \Magento\Swatches\Helper\Data $swatchHelper,
        \Niks\LayeredNavigation\Helper\Data $helper
    ) {
        $this->helper = $helper;
        parent::__construct($layout, $swatchHelper);
    }

    /**
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     * @param \Magento\LayeredNavigation\Block\Navigation\FilterRenderer $subject
     * @param \Closure $proceed
     * @param \Magento\Catalog\Model\Layer\Filter\FilterInterface $filter
     * @return mixed
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function aroundRender(
        \Magento\LayeredNavigation\Block\Navigation\FilterRenderer $subject,
        \Closure $proceed,
        \Magento\Catalog\Model\Layer\Filter\FilterInterface $filter
    ) {
        if ($filter->hasAttributeModel()) {
            if ($this->swatchHelper->isSwatchAttribute($filter->getAttributeModel())) {
                return $this->layout
                    ->createBlock($this->block)
                    ->setSwatchFilter($filter)
                    ->toHtml();
            }
        }

        if ($this->helper->isSliderEnabled()
            && $filter->hasAttributeModel()
            && $filter->getAttributeModel()->getBackendType() == 'decimal'
            && strpos('no-slider', $filter->getAttributeModel()->getFrontendClass()) === false
        ) {
            return $this->layout
                ->createBlock(\Niks\LayeredNavigation\Block\LayeredNavigation\SliderRenderer::class)
                ->setFilter($filter)
                ->toHtml();
        }
        return $proceed($filter);
    }

}
