<?php
namespace Niks\LayeredNavigation\Block;

use Magento\Framework\View\Element\Template;

/**
 * Class AjaxScript
 * @package Niks_LayeredNavigation
 */
class AjaxScript extends Template
{

    /**
     * @var Data
     */
    private $helper;

    /**
     * AjaxScript constructor.
     * @param Template\Context $context
     * @param Data $helper
     * @param array $data
     */
    public function __construct(
        Template\Context $context,
        \Niks\LayeredNavigation\Helper\Data $helper,
        array $data = []
    ) {
        $this->helper = $helper;
        parent::__construct($context, $data);
    }

    /**
     * Get JSON config
     *
     * @return string
     */
    public function getAjaxConfig()
    {
        $config = [
            'disabled'          => !$this->helper->isAjaxEnabled(),
            'filtersContainer'  => '.block.filter',
            'productsContainer' => '.' . \Niks\LayeredNavigation\Plugin\CategoryViewBlock::PRODUCT_LIST_WRAPPER
        ];
        return json_encode($config);
    }
}
