<?php

namespace Niks\LayeredNavigation\Model\Layer\Filter\Item;

use \Magento\Catalog\Model\Layer\Filter\Item\DataBuilder as CoreDataBuilder;

/**
 * DataBuilder
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

class DataBuilder extends CoreDataBuilder
{

    /**
     * Add isActive field to item data
     *
     * @param string $label
     * @param $value
     * @param int $count
     * @param bool $isActive
     */
    public function addItemData($label, $value, $count, $isActive = false)
    {
        $this->_itemsData[] = [
            'label' => $label,
            'value' => $value,
            'count' => $count,
            'is_active' => $isActive
        ];
    }

}
