<?php
namespace Niks\LayeredNavigation\Block\LayeredNavigation;

use Magento\Swatches\Block\LayeredNavigation\RenderLayered as CoreRender;

use Magento\Catalog\Model\Layer\Filter\Item as FilterItem;
use Magento\Eav\Model\Entity\Attribute\Option;

/**
 * Class RenderLayered Render Swatches at Layered Navigation
 *
 * @SuppressWarnings(PHPMD.CouplingBetweenObjects)
 */
class RenderLayered extends CoreRender
{

    protected $_template = 'Niks_LayeredNavigation::product/layered/renderer.phtml';

    /**
     * @param string $attributeCode
     * @param int $optionId
     * @return string
     */
    public function buildUrl($attributeCode, $optionId)
    {
        return $this->_urlBuilder->getFilterUrl(
            $this->filter->getRequestVar(),
            $optionId,
            []
        );
    }

    protected function getOptionViewData(FilterItem $filterItem, Option $swatchOption)
    {
        $customStyle = '';
        $linkToOption = $this->buildUrl($this->eavAttribute->getAttributeCode(), $filterItem->getValue());
        if ($this->isOptionDisabled($filterItem)) {
            $customStyle = 'disabled';
            $linkToOption = 'javascript:void();';
        }

        $activeFilters = $this->filter->getLayer()->getState()->getFilters();
        $isActive = false; $clearLinkUrl = false;
        if(is_array($activeFilters)) {
            foreach($activeFilters as $activeFilter) {
                if((is_array($activeFilter->getValue()) && in_array($filterItem->getValue(), $activeFilter->getValue()))
                    || (!is_array($activeFilter->getValue()) && $filterItem->getValue() == $activeFilter->getValue())
                ) {
                    $isActive = true;
                    $clearLinkUrl = $filterItem->getRemoveUrl();
                }
            }
        }

        return [
            'label' => $swatchOption->getLabel(),
            'link' => $linkToOption,
            'custom_style' => $customStyle,
            'is_active' => $isActive,
            'clear_link_url' => $clearLinkUrl
        ];
    }

}
