<?php

namespace MSP\ReCaptcha\Plugin;

use \Magento\Framework\View\Element\Template\Context;

class Subscribe extends \Magento\Framework\View\Element\Template
{

    public function beforeFetchView() {
        $parent = $this->getNameInLayout();
        if(empty($parent)) {
            $parent = 'form.subscribe';
        }
        $block = 'MSP\ReCaptcha\Block\Frontend\ReCaptcha';
        $alias = 'newsletter-msp-recaptcha-' . rand();
        $arguments = [
            'data' => [
                'jsLayout' => [
                    'components' => [
                        'msp-recaptcha' => [
                            'component' => 'MSP_ReCaptcha/js/reCaptcha',
                            'zone' => 'newsletter'
                        ]
                    ]
                ]
            ]
        ];
        $template = 'MSP_ReCaptcha::msp_recaptcha.phtml';

        if(!in_array($alias, $this->getChildNames())) {
            $recaptchaBlock = $this->getLayout()->createBlock($block, $alias, $arguments)->setTemplate($template);
            if($recaptchaBlock && $this->getLayout()->getBlock($parent) && $this->getLayout()->getBlock("form.additional.info")) {
                $this->setNameInLayout('form.additional.info')->setChild($parent, $recaptchaBlock);
            }
        }
    }

}
