<?php
/**
 * MageSpecialist
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@magespecialist.it so we can send you a copy immediately.
 *
 * @category   MSP
 * @package    MSP_ReCaptcha
 * @copyright  Copyright (c) 2017 Skeeller srl (http://www.magespecialist.it)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

namespace MSP\ReCaptcha\Model\Provider\Failure\RedirectUrl;

use Magento\Framework\App\Response\RedirectInterface;
use MSP\ReCaptcha\Model\Provider\Failure\RedirectUrlProviderInterface;

/**
 * Class ReferrerUrlProvider
 *
 * @package MSP\ReCaptcha\Model\Provider\Failure\RedirectUrl
 */
class ReferrerUrlProvider implements RedirectUrlProviderInterface
{

    /**
     * @var \Magento\Framework\App\Response\RedirectInterface
     */
    private $redirect;

    /**
     * ReferrerUrlProvider constructor.
     *
     * @param \Magento\Framework\App\Response\RedirectInterface $redirect
     */
    public function __construct(
        RedirectInterface $redirect
    ) {
        $this->redirect = $redirect;
    }

    /**
     * Get redirection URL
     *
     * @return string
     */
    public function execute()
    {
        return $this->redirect->getRefererUrl();
    }
}
