<?php
/**
 * InvoiceLoadAfter
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace MSP\CashOnDelivery\Observer\Sales\Order;

use Magento\Framework\Event\ObserverInterface;

class InvoiceLoadAfter implements ObserverInterface
{

    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $invoice = $observer->getInvoice();
        $extensionAttributes = $invoice->getExtensionAttributes();
        if ($extensionAttributes === null) {
            $extensionAttributes = $this->getInvoiceExtensionDependency();
        }

        $baseMspCodAmount = $invoice->getData('base_msp_cod_amount');
        $extensionAttributes->setBaseMspCodAmount($baseMspCodAmount);
        $mspCodAmount = $invoice->getData('msp_cod_amount');
        $extensionAttributes->setMspCodAmount($mspCodAmount);
        $baseMspCodTaxAmount = $invoice->getData('base_msp_cod_tax_amount');
        $extensionAttributes->setBaseMspCodTaxAmount($baseMspCodTaxAmount);
        $mspCodTaxAmount = $invoice->getData('msp_cod_tax_amount');
        $extensionAttributes->setMspCodTaxAmount($mspCodTaxAmount);
        $invoice->setExtensionAttributes($extensionAttributes);
    }


    private function getInvoiceExtensionDependency()
    {
        $invoiceExtension = \Magento\Framework\App\ObjectManager::getInstance()->get(
            '\Magento\Sales\Api\Data\InvoiceExtension'
        );
        return $invoiceExtension;
    }

}
