<?php
/**
 * CreditmemoLoadAfter
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace MSP\CashOnDelivery\Observer\Sales\Order;

use Magento\Framework\Event\ObserverInterface;

class CreditmemoLoadAfter implements ObserverInterface
{

    /**
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $creditmemo = $observer->getCreditmemo();
        $extensionAttributes = $creditmemo->getExtensionAttributes();
        if ($extensionAttributes === null) {
            $extensionAttributes = $this->getCreditmemoExtensionDependency();
        }

        $baseMspCodAmount = $creditmemo->getData('base_msp_cod_amount');
        $extensionAttributes->setBaseMspCodAmount($baseMspCodAmount);
        $mspCodAmount = $creditmemo->getData('msp_cod_amount');
        $extensionAttributes->setMspCodAmount($mspCodAmount);
        $baseMspCodTaxAmount = $creditmemo->getData('base_msp_cod_tax_amount');
        $extensionAttributes->setBaseMspCodTaxAmount($baseMspCodTaxAmount);
        $mspCodTaxAmount = $creditmemo->getData('msp_cod_tax_amount');
        $extensionAttributes->setMspCodTaxAmount($mspCodTaxAmount);
        $creditmemo->setExtensionAttributes($extensionAttributes);
    }

    /**
     * @return mixed
     */
    private function getCreditmemoExtensionDependency()
    {
        $creditmemoExtension = \Magento\Framework\App\ObjectManager::getInstance()->get(
            '\Magento\Sales\Api\Data\CreditmemoExtension'
        );
        return $creditmemoExtension;
    }

}
