<?php
/**
 * IDEALIAGroup srl
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@idealiagroup.com so we can send you a copy immediately.
 *
 * @category   MSP
 * @package    MSP_CashOnDelivery
 * @copyright  Copyright (c) 2016 IDEALIAGroup srl (http://www.idealiagroup.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

namespace MSP\CashOnDelivery\Model\Total\Creditmemo;

use Magento\Sales\Model\Order\Creditmemo;
use MSP\CashOnDelivery\Helper\Data;
use MSP\CashOnDelivery\Api\CashondeliveryInterface;
use Magento\Framework\Pricing\PriceCurrencyInterface;

class Cashondelivery extends AbstractTotal
{

    /**
     * @var Data \MSP\CashOnDelivery\Helper\Data
     */
    protected $dataHelper;
    /**
     * @var Data \MSP\CashOnDelivery\Api\CashondeliveryInterface
     */
    protected $cashOnDeliveryInterface;
    /**
     * @var Data \Magento\Framework\Pricing\PriceCurrencyInterface
     */
    protected $priceCurrencyInterface;

    public function __construct(
        Data $dataHelper,
        CashondeliveryInterface $cashOnDeliveryInterface,
        PriceCurrencyInterface $priceCurrencyInterface,
        array $data = []
    )
    {
        parent::__construct($data);

        $this->dataHelper = $dataHelper;
        $this->cashOnDeliveryInterface = $cashOnDeliveryInterface;
        $this->priceCurrencyInterface = $priceCurrencyInterface;
    }

    public function collect(Creditmemo $creditmemo)
    {
        $order = $creditmemo->getOrder();

        if (!$this->_canApplyTotal($order)) {
            return $this;
        }

        //@todo: Refactoring
        $baseMspCodAmount = $creditmemo->getBaseMspCodAmount();
        if ($creditmemo->getHasChangedBaseMspCodAmount()) {
            if(($baseMspCodAmount > $order->getBaseMspCodAmount()) || ($baseMspCodAmount < 0)) {
                throw new \Magento\Framework\Exception\LocalizedException(
                    __('Maximum Cash on Delivery amount allowed to refund is: %1. Minimum is 0', $order->getBaseMspCodAmount())
                );
            }

            $newBaseMspCodTaxAmount =  $creditmemo->getBaseMspCodTaxAmount();
            $newMspCodTaxAmount =  $creditmemo->getMspCodTaxAmount();

            $creditMemoBaseTaxAmount = $creditmemo->getBaseTaxAmount();
            $creditMemoTaxAmount = $creditmemo->getTaxAmount();
            $creditMemoBaseGrandTotal = $creditmemo->getBaseGrandTotal();
            $creditMemoGrandTotal = $creditmemo->getGrandTotal();

            $oldBaseMspCodTaxAmount = $creditmemo->getBaseMspCodTaxAmount();
            $calculatedBaseMspCodTaxAmount = $this->priceCurrencyInterface->convert($this->cashOnDeliveryInterface->getBaseTaxAmount($baseMspCodAmount));

            //Calcoli presi da \Magento\Sales\Model\Order\Creditmemo\Total\Tax riga 101
            $isPartialShippingRefunded = false;
            $orderShippingAmount = $order->getShippingAmount();
            $baseOrderShippingAmount = $order->getBaseShippingAmount();
            $baseOrderShippingRefundedAmount = $order->getBaseShippingRefunded();
            $shippingDelta = $baseOrderShippingAmount - $baseOrderShippingRefundedAmount;
            if ($shippingDelta > $creditmemo->getBaseShippingAmount()) {
                $part = $creditmemo->getShippingAmount() / $orderShippingAmount;
                if ($part < 1 && $order->getShippingTaxAmount() > 0) {
                    $isPartialShippingRefunded = true;
                }
            }

            if ($isPartialShippingRefunded) {
                //In caso di ricalcolo della shipping magento invece che prendere le tasse partendo dall'ordine prende dai prodotti + shipping ecc quindi non considera il COD.
                //In questo unico caso Ã¨ necessario riaggiungerle (ed Ã¨ corretto secondo la logica di Magento, cioÃ¨ nammerda)
                $creditMemoBaseTaxAmount = $creditmemo->getBaseTaxAmount() + $calculatedBaseMspCodTaxAmount;
                $creditMemoTaxAmount = $creditmemo->getTaxAmount() + $calculatedBaseMspCodTaxAmount;
                $creditMemoBaseGrandTotal = $creditmemo->getBaseGrandTotal() + $calculatedBaseMspCodTaxAmount;
                $creditMemoGrandTotal = $creditmemo->getGrandTotal() + $calculatedBaseMspCodTaxAmount;
            } else {

                if($calculatedBaseMspCodTaxAmount < $oldBaseMspCodTaxAmount) {
                    $newBaseMspCodTaxAmount = $oldBaseMspCodTaxAmount - $calculatedBaseMspCodTaxAmount;
                    $newMspCodTaxAmount = $oldBaseMspCodTaxAmount - $calculatedBaseMspCodTaxAmount;
                    $creditMemoBaseTaxAmount = $creditmemo->getBaseTaxAmount() - $newBaseMspCodTaxAmount;
                    $creditMemoTaxAmount = $creditmemo->getTaxAmount() - $newMspCodTaxAmount;

                    /**
                     * Not sum cod taxes because are already in order's tax_amount.
                     */
//                    $creditMemoBaseGrandTotal = $creditmemo->getBaseGrandTotal() + $creditmemo->getBaseMspCodAmount() - $newBaseMspCodTaxAmount;
//                    $creditMemoGrandTotal = $creditmemo->getGrandTotal() + $creditmemo->getMspCodAmount() - $newMspCodTaxAmount;
                    $creditMemoBaseGrandTotal = $creditmemo->getBaseGrandTotal() - $oldBaseMspCodTaxAmount;
                    $creditMemoGrandTotal = $creditmemo->getGrandTotal() - $oldBaseMspCodTaxAmount;
                }
            }

            $creditmemo->setMspCodAmount($this->priceCurrencyInterface->convert($baseMspCodAmount));
            $creditmemo->setBaseMspCodTaxAmount($calculatedBaseMspCodTaxAmount);
            $creditmemo->setMspCodTaxAmount($calculatedBaseMspCodTaxAmount);
            $creditmemo->setBaseTaxAmount($creditMemoBaseTaxAmount);
            $creditmemo->setTaxAmount($creditMemoTaxAmount);
            $creditmemo->setBaseGrandTotal($creditMemoBaseGrandTotal);
            $creditmemo->setGrandTotal($creditMemoGrandTotal);
            $creditmemo->setHasChangedBaseMspCodAmount(false);
        }

        $creditMemoBaseGrandTotal = $creditmemo->getBaseGrandTotal();
        $creditMemoGrandTotal = $creditmemo->getGrandTotal();

        if($this->dataHelper->calculationCodInclTax()) {
            $codValues = $this->dataHelper->calculateCodInclTax($creditmemo);
            $creditMemoBaseGrandTotal += $codValues['base_value'];
            $creditMemoGrandTotal += $codValues['value'];
        } else {

            /**
             * Not sum cod taxes because are already in order's tax_amount.
             */

//            $codValues = $this->dataHelper->calculateCodExclTax($creditmemo);
//            $creditMemoBaseGrandTotal += $codValues['base_value'] + $codValues['base_tax'];
//            $creditMemoGrandTotal += $codValues['value'] + $codValues['tax'];
//            $creditmemo->setBaseTaxAmount($creditmemo->getBaseTaxAmount() + $codValues['base_tax']);
//            $creditmemo->setTaxAmount($creditmemo->getTaxAmount() + $codValues['tax']);
            $codValues = $this->dataHelper->calculateCodExclTax($creditmemo);
            $creditMemoBaseGrandTotal += $codValues['base_value'];
            $creditMemoGrandTotal += $codValues['value'];
            $creditmemo->setBaseTaxAmount($creditmemo->getBaseTaxAmount());
            $creditmemo->setTaxAmount($creditmemo->getTaxAmount());
        }

        $creditmemo->setBaseGrandTotal($creditMemoBaseGrandTotal);
        $creditmemo->setGrandTotal($creditMemoGrandTotal);

        return $this;
    }
}