<?php
/**
 * CreditmemoLoadAfter
 *
 * @copyright Copyright © 2019 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace MSP\CashOnDelivery\Observer\Sales;

use Magento\Framework\Event\ObserverInterface;

class OrderLoadAfter implements ObserverInterface
{

    /**
     * @param \Magento\Framework\Event\Observer $observer
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $order = $observer->getOrder();
        $extensionAttributes = $order->getExtensionAttributes();
        if ($extensionAttributes === null) {
            $extensionAttributes = $this->getOrderExtensionDependency();
        }

        $baseMspCodAmount = $order->getData('base_msp_cod_amount');
        $extensionAttributes->setBaseMspCodAmount($baseMspCodAmount);
        $mspCodAmount = $order->getData('msp_cod_amount');
        $extensionAttributes->setMspCodAmount($mspCodAmount);
        $baseMspCodTaxAmount = $order->getData('base_msp_cod_tax_amount');
        $extensionAttributes->setBaseMspCodTaxAmount($baseMspCodTaxAmount);
        $mspCodTaxAmount = $order->getData('msp_cod_tax_amount');
        $extensionAttributes->setMspCodTaxAmount($mspCodTaxAmount);
        $order->setExtensionAttributes($extensionAttributes);
    }

    /**
     * @return mixed
     */
    private function getOrderExtensionDependency()
    {
        $orderExtension = \Magento\Framework\App\ObjectManager::getInstance()->get(
            '\Magento\Sales\Api\Data\OrderExtension'
        );
        return $orderExtension;
    }

}
