<?php
/**
 * IDEALIAGroup srl
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@idealiagroup.com so we can send you a copy immediately.
 *
 * @category   MSP
 * @package    MSP_CashOnDelivery
 * @copyright  Copyright (c) 2016 IDEALIAGroup srl (http://www.idealiagroup.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

namespace MSP\CashOnDelivery\Model\Total\Invoice;

use Magento\Sales\Model\Order\Invoice;
use MSP\CashOnDelivery\Helper\Data;

class Cashondelivery extends AbstractTotal
{

    /**
     * @var Data \MSP\CashOnDelivery\Helper\Data
     */
    protected $dataHelper;

    public function __construct(
        Data $dataHelper,
        array $data = []
    )
    {
        parent::__construct($data);

        $this->dataHelper = $dataHelper;
    }

    public function collect(Invoice $invoice)
    {

        $order = $invoice->getOrder();
        if (!$this->_canApplyTotal($order)) {
            return $this;
        }

        $invoiceBaseGrandTotal = $invoice->getBaseGrandTotal();
        $invoiceGrandTotal = $invoice->getGrandTotal();

        if($this->dataHelper->calculationCodInclTax()) {
            $codValues = $this->dataHelper->calculateCodInclTax($invoice);
            $invoiceBaseGrandTotal += $codValues['base_value'];
            $invoiceGrandTotal += $codValues['value'];
        } else {
            $codValues = $this->dataHelper->calculateCodExclTax($invoice);
            $invoiceBaseGrandTotal += $codValues['base_value'] + $codValues['base_tax'];
            $invoiceGrandTotal += $codValues['value'] + $codValues['tax'];
            $invoice->setBaseTaxAmount($invoice->getBaseTaxAmount() + $codValues['base_tax']);
            $invoice->setTaxAmount($invoice->getTaxAmount() + $codValues['tax']);
        }

        $invoice->setBaseGrandTotal($invoiceBaseGrandTotal);
        $invoice->setGrandTotal($invoiceGrandTotal);
        return $this;
    }
}
