<?php
/**
 * IDEALIAGroup srl
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@idealiagroup.com so we can send you a copy immediately.
 *
 * @category   MSP
 * @package    MSP_CashOnDelivery
 * @copyright  Copyright (c) 2016 IDEALIAGroup srl (http://www.idealiagroup.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

namespace MSP\CashOnDelivery\Block\Sales;

use Magento\Framework\View\Element\Template;
use Magento\Framework\DataObject;
use Magento\Sales\Api\Data\CreditmemoInterface;
use Magento\Sales\Api\Data\InvoiceInterface;
use Magento\Sales\Api\Data\OrderInterface;
use MSP\CashOnDelivery\Model\Payment;

class Cashondelivery extends Template
{

    /**
     * Tax configuration model
     *
     * @var \Magento\Tax\Model\Config
     */
    protected $_config;

    /**
     * @var \MSP\CashOnDelivery\Helper\Data
     */
    protected $helperData;

    /**
     * @param \Magento\Framework\View\Element\Template\Context $context
     * @param \Magento\Tax\Model\Config $taxConfig
     * @param \MSP\CashOnDelivery\Helper\Data $helperData
     * @param array $data
     */
    public function __construct(
        \Magento\Framework\View\Element\Template\Context $context,
        \Magento\Tax\Model\Config $taxConfig,
        \MSP\CashOnDelivery\Helper\Data $helperData,
        array $data = []
    ) {
        $this->_config = $taxConfig;
        $this->helperData = $helperData;
        parent::__construct($context, $data);
    }

    public function displayFullSummary()
    {
        return $this->_config->displaySalesFullSummary($this->getOrder()->getStore());
    }

    public function initTotals()
    {
        $parent = $this->getParentBlock();
        $source = $parent->getSource();

        if($this->helperData->calculationCodInclTax()) {
            $codValues = $this->helperData->calculateCodInclTax($source);
        } else {
            $codValues = $this->helperData->calculateCodExclTax($source);
        }


        $payment = $this->getPayment($source);
        if (!$source->getIsVirtual() && $payment && ($payment->getMethod() == Payment::CODE) && ((double)$source->getMspCodAmount())) {

            $label = __('Cash on delivery');
            if($this->helperData->displaySalesCodBoth()) {
                $label = __('Cash on delivery (Excl.Tax)');
            }

            $fee = new DataObject(
                [
                    'code' => 'msp_cashondelivery',
                    'strong' => false,
                    'value' => $codValues['value'],
                    'base_value' => $codValues['base_value'],
                    'label' => $label,
                ]
            );
            $parent->addTotalBefore($fee, 'tax');

            if($this->helperData->displaySalesCodBoth() && ($codValues['tax'] > 0)) {
                $taxFee = new DataObject(
                    [
                        'code' => 'msp_cashondelivery_tax',
                        'strong' => false,
                        'value' => $codValues['tax'],
                        'base_value' => $codValues['base_tax'],
                        'label' => __('Cash on delivery (Incl.Tax)'),
                    ]
                );
                $parent->addTotalBefore($taxFee, 'tax');
            }
 
        }

        return $this;
    }

    protected function getPayment($source)
    {
        if ($source instanceof InvoiceInterface) {
            return $source->getOrder()->getPayment();
        }

        if ($source instanceof OrderInterface) {
            return $source->getPayment();
        }

        if ($source instanceof CreditMemoInterface) {
            return $source->getOrder()->getPayment();
        }

        return null;
    }
}
