/**
 * IDEALIAGroup srl
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@idealiagroup.com so we can send you a copy immediately.
 *
 * @category   MSP
 * @package    MSP_CashOnDelivery
 * @copyright  Copyright (c) 2016 IDEALIAGroup srl (http://www.idealiagroup.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

/*jshint browser:true jquery:true*/
/*global alert*/
define(
    [
        'ko',
        'Magento_Checkout/js/view/summary/abstract-total',
        'Magento_Checkout/js/model/quote',
        'Magento_Catalog/js/price-utils',
        'Magento_Checkout/js/model/totals'
    ],
    function (ko, Component, quote, priceUtils, totals) {
        "use strict";
        return Component.extend({
            defaults: {
                isFullTaxSummaryDisplayed: window.checkoutConfig.isFullTaxSummaryDisplayed || false,
                template: 'MSP_CashOnDelivery/checkout/summary/cashondelivery'
            },
            totals: quote.getTotals(),
            isTaxDisplayedInGrandTotal: window.checkoutConfig.includeTaxInGrandTotal || false,
            isCalculationCodInclTax: window.checkoutConfig.calculationCodIncludeTax || false,
            isDisplayed: function () {
                return this.isFullMode();
            },
            hasTotal: function () {
                if (this.totals()) {
                    return !!totals.getSegment('msp_cashondelivery');
                }

                return false;
            },
            getValue: function () {
                var price = 0;
                if (this.hasTotal()) {
                    price = totals.getSegment('msp_cashondelivery').value;
                    if(!this.isCalculationCodInclTax) {
                        price += totals.getSegment('msp_cashondelivery_tax').value;
                    }
                }
                return this.getFormattedPrice(price);
            },
            getBaseValue: function () {
                var price = 0;
                if (this.hasTotal()) {
                    price = totals.getSegment('msp_cashondelivery').value;
                    if(!this.isCalculationCodInclTax) {
                        price += totals.getSegment('msp_cashondelivery_tax').value;
                    }
                }
                return this.getFormattedPrice(price);
            },
            shouldDisplay: function () {
                var price = 0;
                if (this.hasTotal()) {
                    price = totals.getSegment('msp_cashondelivery').value;
                    if(!this.isCalculationCodInclTax) {
                        price += totals.getSegment('msp_cashondelivery_tax').value;
                    }
                }

                return price;
            }
        });
    }
);
