<?php

namespace MSP\CashOnDelivery\Block\Adminhtml\Order\Creditmemo\Create;

use Magento\Framework\Pricing\PriceCurrencyInterface;

class Adjustments extends \Magento\Backend\Block\Template
{
    /**
     * Source object
     *
     * @var \Magento\Framework\DataObject
     */
    protected $_source;

    /**
     * Tax config
     *
     * @var \MSP\CashOnDelivery\Helper\Data
     */
    protected $helperData;

    /**
     * @var PriceCurrencyInterface
     */
    protected $priceCurrency;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Tax\Model\Config $taxConfig
     * @param PriceCurrencyInterface $priceCurrency
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \MSP\CashOnDelivery\Helper\Data $helperData,
        PriceCurrencyInterface $priceCurrency,
        array $data = []
    ) {
        $this->helperData = $helperData;
        $this->priceCurrency = $priceCurrency;
        parent::__construct($context, $data);
    }

    /**
     * Initialize creditmemo agjustment totals
     *
     * @return $this
     */
    public function initTotals()
    {
        $parent = $this->getParentBlock();
        $this->_source = $parent->getSource();
        $total = new \Magento\Framework\DataObject(['code' => 'msp_cashondelivery_adjustments', 'block_name' => $this->getNameInLayout()]);
        $parent->removeTotal('msp_cashondelivery');
        $parent->removeTotal('msp_cashondelivery_tax');
        $parent->addTotal($total);
        return $this;
    }

    /**
     * Get source object
     *
     * @return \Magento\Framework\DataObject
     */
    public function getSource()
    {
        return $this->_source;
    }

    /**
     * Get credit memo shipping amount depend on configuration settings
     *
     * @return float
     */
    public function getMspCodAmount()
    {
        $source = $this->getSource();
        if($this->helperData->calculationCodInclTax()) {
            if($this->helperData->displaySalesCodInclTax()) {
                $codAmount = $source->getBaseMspCodAmount();
            } elseif($this->helperData->displaySalesCodBoth()) {
                $codAmount = $source->getMspCodAmount() - $source->getMspCodTaxAmount();
            } else {
                $codAmount = $source->getMspCodAmount() - $source->getMspCodTaxAmount();
            }
        } else {
            if($this->helperData->displaySalesCodInclTax()) {
                $codAmount = $source->getMspCodAmount() + $source->getMspCodTaxAmount();
            } elseif($this->helperData->displaySalesCodBoth()) {
                $codAmount = $source->getMspCodAmount();
            } else {
                $codAmount = $source->getMspCodAmount();
            }
        }
        return $this->priceCurrency->round($codAmount) * 1;
    }

    /**
     * Get label for shipping total based on configuration settings
     *
     * @return string
     */
    public function getCodLabel()
    {
        $source = $this->getSource();
        $label = __('Cash on delivery');
        if($this->helperData->displaySalesCodBoth()) {
            $label = __('Cash on delivery (Excl.Tax)');
        }
        return $label;
    }

}
