<?php

/*
 * Description: Data.php
 * @date: 18-mag-2018
 * @author Simone Monterubbiano <s.monterubbiano@drop.it>
 */
namespace MSP\CashOnDelivery\Helper;

class Data extends \Magento\Framework\App\Helper\AbstractHelper{

    /**
     * \Magento\Framework\App\Config\ScopeConfigInterface
     *
     * @var type
     */
    protected $scopeConfig;

    const XML_PATH_CALCULATION_COD = 'tax/calculation/cod_includes_tax';
    const XML_PATH_DISPLAY_COD = 'tax/display/cod';
    const XML_PATH_DISPLAY_SALES_COD = 'tax/sales_display/cod';

    const CALCULATION_EXCLUDING_TAX = 0;
    const CALCULATION_INCLUDING_TAX = 1;

    const DISPLAY_TYPE_EXCLUDING_TAX = 1;
    const DISPLAY_TYPE_INCLUDING_TAX = 2;
    const DISPLAY_TYPE_BOTH = 3;

    const SALES_DISPLAY_TYPE_EXCLUDING_TAX = 1;
    const SALES_DISPLAY_TYPE_INCLUDING_TAX = 2;
    const SALES_DISPLAY_TYPE_BOTH = 3;

    /**
     * Data constructor.
     * @param \Magento\Framework\App\Helper\Context $context
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
    ) {
        $this->scopeConfig = $scopeConfig;
    }

    /**
     * Get object manager
     *
     * @return \Magento\Framework\App\ObjectManager
     */
    public function getObjectManager()
    {
        return \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function displaySalesCodExclTax($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_DISPLAY_SALES_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::SALES_DISPLAY_TYPE_EXCLUDING_TAX;
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function displaySalesCodInclTax($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_DISPLAY_SALES_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::SALES_DISPLAY_TYPE_INCLUDING_TAX;
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function displaySalesCodBoth($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_DISPLAY_SALES_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::SALES_DISPLAY_TYPE_BOTH;
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function displayCodExclTax($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_DISPLAY_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::DISPLAY_TYPE_EXCLUDING_TAX;
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function displayCodInclTax($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_DISPLAY_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::DISPLAY_TYPE_INCLUDING_TAX;
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function displayCodBoth($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_DISPLAY_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::DISPLAY_TYPE_BOTH;
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function calculationCodExclTax($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_CALCULATION_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::CALCULATION_EXCLUDING_TAX;
    }

    /**
     * @param null|string|bool|int|Store $store
     * @return bool
     */
    public function calculationCodInclTax($store = null)
    {
        return $this->scopeConfig->getValue(
                self::XML_PATH_CALCULATION_COD,
                \Magento\Store\Model\ScopeInterface::SCOPE_STORE,
                $store
            ) == self::DISPLAY_TYPE_INCLUDING_TAX;
    }

}
