<?php
/**
 * IDEALIAGroup srl
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to info@idealiagroup.com so we can send you a copy immediately.
 *
 * @category   MSP
 * @package    MSP_CashOnDelivery
 * @copyright  Copyright (c) 2016 IDEALIAGroup srl (http://www.idealiagroup.com)
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

namespace MSP\CashOnDelivery\Model\Total\Creditmemo;

use Magento\Sales\Model\Order\Creditmemo;
use MSP\CashOnDelivery\Helper\Data;

class Cashondelivery extends AbstractTotal
{

    /**
     * @var Data \MSP\CashOnDelivery\Helper\Data
     */
    protected $dataHelper;

    public function __construct(
        Data $dataHelper,
        array $data = []
    )
    {
        parent::__construct($data);

        $this->dataHelper = $dataHelper;
    }

    public function collect(Creditmemo $creditmemo)
    {
        $order = $creditmemo->getOrder();

        $creditmemo->setMspCodAmount($order->getMspCodAmount());
        $creditmemo->setBaseMspCodAmount($order->getBaseMspCodAmount());

        $creditMemoBaseGrandTotal = $creditmemo->getBaseGrandTotal();
        $creditMemoGrandTotal = $creditmemo->getGrandTotal();
        if($this->dataHelper->calculationCodExclTax()) {
            $creditMemoBaseGrandTotal += $creditmemo->getBaseMspCodAmount() + $creditmemo->getBaseMspCodTaxAmount();
            $creditMemoGrandTotal += $creditmemo->getMspCodAmount() + $creditmemo->getMspCodTaxAmount();
        } elseif($this->dataHelper->calculationCodInclTax()) {
            $creditMemoBaseGrandTotal += $creditmemo->getBaseMspCodAmount();
            $creditMemoGrandTotal += $creditmemo->getMspCodAmount();
        }

        if ($this->_canApplyTotal($order)) {
            $creditmemo->setGrandTotal($creditMemoGrandTotal);
            $creditmemo->setBaseGrandTotal($creditMemoBaseGrandTotal);
        }

        return $this;
    }
}
