<?php
/**
 * ConfigProvider
 *
 * @copyright Copyright © 2018 Drop. All rights reserved.
 * @author    c.pieroni@drop.it
 */

namespace MSP\CashOnDelivery\Model\Config;

use Magento\Checkout\Model\ConfigProviderInterface;
use MSP\CashOnDelivery\Helper\Data;
use Magento\Store\Model\StoreManagerInterface;

class ConfigProvider implements ConfigProviderInterface
{
    /**
     * @var \MSP\CashOnDelivery\Helper\Data
     */
    protected $helperData;

    /**
     * @var \Magento\Store\Model\StoreManagerInterface
     */
    protected $_storeManager;

    /**
     * ConfigProvider constructor.
     * @param \MSP\CashOnDelivery\Helper\Data $helperData
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     */
    public function __construct(
        Data $helperData,
        StoreManagerInterface $storeManager
    ) {
        $this->helperData = $helperData;
        $this->_storeManager = $storeManager;
    }

    public function getConfig()
    {
        $config = [];
        $config['msp_cashondelivery']['calculationCodIncludeTax'] = $this->helperData->calculationCodInclTax($this->_storeManager->getStore()->getStoreId());
        return $config;
    }
}
