<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.8
 * @copyright Copyright (C) 2020 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Model\Banner\Rule\Condition;

use Magento\Framework\App\ObjectManager;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\UrlInterface;
use Magento\Rule\Model\Condition\AbstractCondition;
use Magento\Rule\Model\Condition\Context;

/**
 * @method getAttribute()
 * @method getJsFormObject()
 */
class PageCondition extends AbstractCondition
{
    private $urlManager;


    private $context;

    public function __construct(
        UrlInterface $urlManager,
        Context $context,
        array $data = []
    ) {
        $this->urlManager = $urlManager;
        $this->context    = $context;

        parent::__construct($context, $data);
    }

    public function loadAttributeOptions()
    {
        $attributes = [
            'page_type' => (string)__('Page Type'),
            'uri'       => (string)__('URI'),
        ];

        asort($attributes);
        $this->setData('attribute_option', $attributes);

        return $this;
    }

    /**
     * {@inheritdoc}
     */
    public function getInputType()
    {
        switch ($this->getAttribute()) {
            case 'page_type':
            case 'product_type':
            case 'customer_group':
            case 'store':
                return 'multiselect';

            case 'popularity':
                return 'numeric';

            default:
                return 'string';
        }
    }

    /**
     * {@inheritdoc}
     */
    public function getValueElementType()
    {
        switch ($this->getAttribute()) {
            case 'page_type':
            case 'product_type':
            case 'customer_group':
            case 'store':
                return 'multiselect';

            default:
                return 'text';
        }
    }

    /**
     * {@inheritdoc}
     */
    public function getValueOption($option = null)
    {
        $om      = ObjectManager::getInstance();
        $options = [];

        switch ($this->getAttribute()) {
            case 'page_type':
                /** @var \Magento\Framework\View\Layout\PageType\Config $config */
                $config = $om->get('Magento\Framework\View\Layout\PageType\Config');

                foreach ($config->getPageTypes() as $type => $info) {
                    $options[$type] = $info['label'];
                }

                break;
        }

        $this->setData('value_option', $options);

        return $this->getData('value_option' . ($option !== null ? '/' . $option : ''));
    }

    /**
     * {@inheritdoc}
     */
    public function getValueParsed()
    {
        return $this->getData('value');
    }

    /**
     * @param AbstractModel $object
     *
     * @return bool
     */
    public function validate(AbstractModel $object)
    {
        $result = null;

        switch ($this->getAttribute()) {
            case 'page_type':
            case 'uri':
                $value = $object->getData($this->getAttribute());

                $result = $this->validateAttribute($value);

                break;

            default:
                return true;
        }

        return $result;
    }
}
