<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.4
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Service;

use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Checkout\Model\Session as CheckoutSession;
use Magento\Cms\Model\Template\FilterProvider;
use Magento\Customer\Model\Session as CustomerSession;
use Magento\Store\Model\StoreManagerInterface;
use Mirasvit\PromoBanner\Api\Data\BannerInterface;
use Mirasvit\PromoBanner\Api\Repository\BannerRepositoryInterface;

class BannerService
{
    private $bannerRepository;

    private $customerSession;

    private $checkoutSession;

    private $filterProvider;

    private $storeManager;

    private $productRepository;

    public function __construct(
        BannerRepositoryInterface $bannerRepository,
        CustomerSession $customerSession,
        CheckoutSession $checkoutSession,
        FilterProvider $filterProvider,
        StoreManagerInterface $storeManager,
        ProductRepositoryInterface $productRepository
    ) {
        $this->bannerRepository  = $bannerRepository;
        $this->customerSession   = $customerSession;
        $this->checkoutSession   = $checkoutSession;
        $this->filterProvider    = $filterProvider;
        $this->storeManager      = $storeManager;
        $this->productRepository = $productRepository;
    }

    public function getBanners(array $params)
    {
        $result = [];

        $customerGroupId = $this->customerSession->isLoggedIn() ? $this->customerSession->getCustomer()->getGroupId() : 0;
        $storeId         = $this->storeManager->getStore()->getId();

        $quote = $this->checkoutSession->getQuote();

        $collection = $this->bannerRepository->getCollection()
            ->addFieldToFilter(BannerInterface::IS_ACTIVE, 1)
            ->addDateFilter()
            ->addCustomerGroupFilter($customerGroupId)
            ->addStoreFilter($storeId);

        $allItems = [];

        if (isset($params['product_id']) && $params['product_id']) {
            $product = $this->productRepository->getById($params['product_id'], true);
            $product->setData('product', $product);
            $allItems[] = $product;
        }

        foreach ($quote->getAllItems() as $item) {
            $allItems[] = $item;
        }

        /** @var BannerInterface $banner */
        foreach ($collection as $banner) {

            $dataObject = $banner->getRule()->getDataObject($params);
            $dataObject->setData('quote', $quote)
                ->setData('all_items', $allItems);

            $isValid = $banner->getRule()->validate($dataObject);

            if (!$isValid) {
                continue;
            }

            foreach ($banner->getPositions() as $position) {
                $content = $this->filterProvider->getBlockFilter()
                    ->filter($banner->getContent());

                $result[] = [
                    'position' => $position,
                    'content'  => $content,
                ];
            }
        }

        return $result;
    }
}