<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.4
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Block;

use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;

class Placeholder extends Template
{
    protected $_template = 'Mirasvit_PromoBanner::placeholder.phtml';

    public function __construct(
        Context $context
    ) {
        parent::__construct($context);
    }

    public function setPosition($position)
    {
        return $this->setData('position', $position);
    }

    public function getPosition()
    {
        return $this->getData('position');
    }
}
