<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.2.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\SalesRule\Controller\Adminhtml\Rule;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\ResponseInterface;
use Mirasvit\SalesRule\Block\Adminhtml\Evaluator as EvaluatorBlock;

class Evaluator extends Action
{
    private $response;

    private $block;

    public function __construct(
        ResponseInterface $response,
        EvaluatorBlock    $block,
        Context           $context
    ) {
        $this->response = $response;
        $this->block    = $block;

        parent::__construct($context);
    }

    public function execute()
    {
        $this->block->setActionData($this->getRequest()->getParams());
        $content = $this->block->toHtml();

        return $this->response->representJson(\Zend_Json::encode(
            ['content' => $content]
        ));
    }
}
