<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.2.8
 * @copyright Copyright (C) 2023 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);


namespace Mirasvit\SalesRule\Rule;


use Magento\Quote\Model\Quote\Item\AbstractItem;
use Magento\SalesRule\Model\Rule;
use Magento\SalesRule\Model\Rule\Action\Discount\Data as DiscountData;

class CheapestFixedWithStepType extends CheapestWithStepType
{
    public function getType(): string
    {
        return 'mst_cheapest_fixed_with_step';
    }

    public function getLabel(): string
    {
        return 'Fixed Discount for Cheapest products by step';
    }

    protected function getDiscountData(Rule $rule, AbstractItem $item, float $qty): DiscountData
    {
        $discountData = $this->context->discountDataFactory->create();

        if (!$item) {
            return $discountData;
        }

        $discountAmount = (float)$rule->getDiscountAmount();

        if ($discountAmount < 0.01) {
            return $discountData;
        }

        $itemPrice = (float)$this->context->validator->getItemPrice($item);
        $discountData->setAmount($qty * $this->fixDiscountAmount($itemPrice, $discountAmount));

        $baseItemPrice = (float)$this->context->validator->getItemBasePrice($item);
        $discountData->setBaseAmount($qty * $this->fixDiscountAmount($baseItemPrice, $discountAmount));

        $itemOriginalPrice = (float)$this->context->validator->getItemOriginalPrice($item);
        $discountData->setOriginalAmount($qty * $this->fixDiscountAmount($itemOriginalPrice, $discountAmount));

        $baseItemOriginalPrice = (float)$this->context->validator->getItemBaseOriginalPrice($item);
        $discountData->setBaseOriginalAmount($qty * $this->fixDiscountAmount($baseItemOriginalPrice, $discountAmount));

        return $discountData;
    }

    public function getDiscountType(): string
    {
        return '$';
    }

    public function fixDiscountAmount(float $price, float $discountAmount): float
    {
        return $discountAmount > $price ? $price : $discountAmount;
    }
}
