define([
    'jquery',
    'underscore',
    'Mirasvit_SalesRule/js/utils',
    'uiElement',
    'uiRegistry',
    'mage/translate'
], function ($, _, utils, Element, Registry) {
    return Element.extend({
        defaults: {
            template: 'Mirasvit_SalesRule/rule/form/interpreter',

            visible: true,

            imports: {
                conditions:          '${ $.provider }:data.conditions_serialized',
                simpleAction:        '${ $.provider }:data.simple_action',
                discountAmount:      '${ $.provider }:data.discount_amount',
                discountQty:         '${ $.provider }:data.discount_qty',
                discountStep:        '${ $.provider }:data.discount_step',
                applyToShipping:     '${ $.provider }:data.apply_to_shipping',
                stopRulesProcessing: '${ $.provider }:data.stop_rules_processing'
            },

            listens: {
                simpleAction: 'updateSimpleActionLabel'
            }
        },

        initialize: function () {
            this._super();

            _.bindAll(this, 'show', 'hide');
        },

        initObservable: function () {
            this._super()
                .observe({
                    conditions:          null,
                    simpleAction:        null,
                    simpleActionLabel:   null,
                    discountAmount:      null,
                    discountQty:         null,
                    discountStep:        null,
                    applyToShipping:     null,
                    stopRulesProcessing: null,
                    visible:             this.visible
                });

            return this;
        },

        show: function () {
            this.visible(true);
        },
        hide: function () {
            this.visible(false);
        },

        updateSimpleActionLabel: function () {
            utils.registry(this.parentName + '.actions.simple_action', function (el) {
                var opt = _.findWhere(el.options(), {value: this.simpleAction()});
                this.simpleActionLabel(opt.label);
            }, this);
        },

        ruleTypeHint: function () {
            var nativeActions = [
                'by_percent',
                'by_fixed',
                'cart_fixed',
                'buy_x_get_y'
            ];

            var mstActions = [
                'mst_each_x_m_get_y_m',
                'mst_most_expensive',
                'mst_most_cheapest',
                'mst_except_expensive',
                'mst_buy_x_get_y',
                'mst_buy_x_get_amount_y',
                'mst_cheapest_with_step'
            ];

            if (nativeActions.includes(this.simpleAction())) {
                return 'Native Rule';
            }

            if (mstActions.includes(this.simpleAction())) {
                return 'Extended Cart Rule';
            }

            return '3rd-party Rule';
        },

        money: function (val) {
            val = _.isFunction(val) ? val() : val;

            return val ? '$' + val : '-';
        },

        qty: function (val) {
            val = _.isFunction(val) ? val() : val;

            return val && val > 0 ? '× ' + val : '-';
        },

        percent: function (val) {
            val = _.isFunction(val) ? val() : val;

            return val ? val + '%' : '-';
        },

        evaluate: function () {
            $.ajax(window.MST_EVALUATOR_URL, {
                method:  'get',
                data:    {
                    discountAmount: this.discountAmount,
                    discountQty:    this.discountQty,
                    discountStep:   this.discountStep,
                    simpleAction:   this.simpleAction
                },
                success: function (response) {
                    $('#evaluator')[0].innerHTML = response.content;
                }
            });
        }
    })
});
