<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.2.2
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\SalesRule\Service\Evaluator;

use Magento\Framework\DataObject;

class Item extends DataObject
{
    public function setName(string $name): self
    {
        $this->setData('name', $name);

        return $this;
    }

    public function getName(): string
    {
        return $this->getData('name') ? : '';
    }

    public function setPrice(string $price): self
    {
        $this->setData('price', $price);

        return $this;
    }

    public function getPrice(): string
    {
        return $this->getData('price') ? : '';
    }

    public function setQty(float $qty): self
    {
        $this->setData('qty', $qty);

        return $this;
    }

    public function getQty(): float
    {
        return $this->getData('qty') ? : 0;
    }

    public function setDiscountAmount(float $discountAmount): self
    {
        $this->setData('discountAmount', $discountAmount);

        return $this;
    }

    public function getDiscountAmount(): float
    {
        return $this->getData('discountAmount') ? : 0;
    }

    public function setDiscountQty(float $discountQty): self
    {
        $this->setData('discountQty', $discountQty);

        return $this;
    }

    public function getDiscountQty(): float
    {
        return $this->getData('discountQty') ? : 0;
    }

    public function setComment(string $comment): self
    {
        $this->setData('comment', $comment);

        return $this;
    }

    public function getComment(): string
    {
        return $this->getData('comment') ? : '';
    }
}
