<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.2.2
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\SalesRule\Block\Adminhtml;

use Magento\Framework\View\Element\Template;
use Mirasvit\SalesRule\Api\Repository\RuleTypeRepositoryInterface;
use Mirasvit\SalesRule\Service\Evaluator\Item;

class Evaluator extends Template
{
    protected $_template = 'Mirasvit_SalesRule::rule/form/evaluator.phtml';

    private   $actionData;

    private   $ruleTypeRepository;

    public function __construct(
        RuleTypeRepositoryInterface $ruleTypeRepository,
        Template\Context            $context,
        array                       $data = []
    ) {
        $this->ruleTypeRepository = $ruleTypeRepository;

        parent::__construct($context, $data);
    }

    public function getCartExamples(): array
    {
        $examples = [
            'carts'        => [],
            'discountType' => '',
        ];

        $rules = $this->ruleTypeRepository->getList();

        if (!isset($this->actionData['simpleAction'])) {
            return $examples;
        }

        $rule = null;

        foreach ($rules as $r) {
            if ($r->getType() == $this->actionData['simpleAction']) {
                $rule = $r;

                break;
            }
        }

        if (!$rule) {
            return $examples;
        }

        $examples['carts'] = $rule->evaluate(
            (float)$this->actionData['discountAmount'],
            (float)$this->actionData['discountQty'],
            (float)$this->actionData['discountStep']
        );

        $examples['discountType'] = $rule->getDiscountType();

        return $examples;
    }

    public function setActionData(array $data): self
    {
        $this->actionData = $data;

        return $this;
    }

    public function getDiscountOutput(Item $item, string $discountType): string
    {
        if (!$item->getDiscountAmount() || !$item->getDiscountQty()) {
            return '&mdash;';
        }

        $discountFormatted = $discountType == '%'
            ? $item->getDiscountAmount() . $discountType
            : $discountType . $item->getDiscountAmount();

        return $item->getQty() > 1 || $item->getDiscountQty() > 1
            ? $discountFormatted . ' <span>×' . $item->getDiscountQty() . '</span>'
            : $discountFormatted;
    }

    public function getProductName(Item $item, int $idx): string
    {
        return $item->getName() ? : 'Product ' . ($idx + 1);
    }
}
