<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.6
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\SalesRule\Rule;

use Mirasvit\SalesRule\Api\Data\RuleTypeInterface;

class BuyXGetAmountYType implements RuleTypeInterface
{
    private $context;

    public function __construct(
        Context $context
    ) {
        $this->context = $context;
    }

    public function getType()
    {
        return 'mst_buy_x_get_amount_y';
    }

    public function getLabel()
    {
        return 'Buy product X Get $ discount for product Y';
    }

    public function calculate($rule, $item, $qty)
    {
        $discountData = $this->context->discountDataFactory->create();

        $discountAmount = $rule->getDiscountAmount();

        $discountQty = $rule->getDiscountQty();

        if ($discountAmount < 0.01) {
            return $discountData;
        }

        if ($discountQty && $qty > $discountQty) {
            $qty = $discountQty;
        }

        $discountData->setAmount($qty * $discountAmount);

        $discountData->setBaseAmount($qty * $discountAmount);

        $discountData->setOriginalAmount($qty * $discountAmount);

        $discountData->setBaseOriginalAmount($qty * $discountAmount);

        return $discountData;
    }
}