<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.6
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Ui\Banner\Form;

use Magento\Ui\DataProvider\AbstractDataProvider;
use Mirasvit\PromoBanner\Api\Data\BannerInterface;
use Mirasvit\PromoBanner\Api\Repository\BannerRepositoryInterface;

class DataProvider extends AbstractDataProvider
{
    /**
     * @var BannerRepositoryInterface
     */
    private $bannerRepository;

    public function __construct(
        BannerRepositoryInterface $bannerRepository,
        $name,
        $primaryFieldName,
        $requestFieldName,
        array $meta = [],
        array $data = []
    ) {
        $this->bannerRepository = $bannerRepository;
        $this->collection       = $this->bannerRepository->getCollection();

        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
    }

    /**
     * {@inheritdoc}
     */
    public function getData()
    {
        $result = [];

        foreach ($this->collection as $banner) {
            $bannerData = $banner->getData();

            $result[$banner->getId()] = $bannerData;
        }

        return $result;
    }
}
