<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.1.1
 * @copyright Copyright (C) 2022 Mirasvit (https://mirasvit.com/)
 */


declare(strict_types=1);

namespace Mirasvit\SalesRule\Service\Evaluator;

use Magento\Framework\DataObject;

class Cart extends DataObject
{
    private $items   = [];

    private $comment = '';

    public function getComment(): string
    {
        return $this->comment;
    }

    public function setComment(string $comment = ''): self
    {
        $this->comment = $comment;

        return $this;
    }

    public function addItem(
        string $name,
        string $price,
        float  $qty,
        float  $discountAmount = 0.0,
        float  $discountQty = 0.0,
        string $comment = ''
    ): self {
        $item = new Item();

        $item->setName($name)
            ->setPrice($price)
            ->setQty($qty)
            ->setDiscountAmount($discountAmount)
            ->setDiscountQty($discountQty)
            ->setComment($comment);

        $this->items[] = $item;

        return $this;
    }

    /** @return Item[] */
    public function getItems(): array
    {
        return $this->items;
    }

    public function setTotal(string $total): self
    {
        $this->setData('total', $total);

        return $this;
    }

    public function getTotal(): ?string
    {
        return $this->getData('total') ? : null;
    }

    public function setTotalDiscount(string $discount): self
    {
        $this->setData('totalDiscount', $discount);

        return $this;
    }

    public function getTotalDiscount(): ?string
    {
        return $this->getData('totalDiscount') ? : null;
    }
}
