<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.9
 * @copyright Copyright (C) 2020 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Controller\Banner;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Mirasvit\PromoBanner\Service\BannerService;

class Loader extends Action
{
    /**
     * @var BannerService
     */
    private $bannerService;

    /**
     * Loader constructor.
     * @param BannerService $bannerService
     * @param Context $context
     */
    public function __construct(
        BannerService $bannerService,
        Context $context
    ) {
        $this->bannerService = $bannerService;

        parent::__construct($context);
    }

    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD)
     */
    public function execute()
    {
        $params = $this->getRequest()->getParams();

        /** @var \Magento\Framework\App\Response\Http $response */
        $response = $this->getResponse();
        $response->representJson(\Zend_Json_Encoder::encode([
            'banners' => $this->bannerService->getBanners($params),
            'success' => true,
        ]));
    }
}
