<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.9
 * @copyright Copyright (C) 2020 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Block\Widget;

use Magento\Framework\DataObject\IdentityInterface;
use Magento\Framework\View\Element\Template;
use Magento\Widget\Block\BlockInterface;

class TextBanner extends Template implements BlockInterface, IdentityInterface
{
    /**
     * @var string
     */
    protected $_template = 'Mirasvit_PromoBanner::widget/text-banner.phtml';

    /**
     * @return mixed
     */
    public function getText()
    {
        return $this->getData('text');
    }

    /**
     * @return mixed
     */
    public function getLink()
    {
        return $this->getData('url');
    }

    /**
     * @return mixed
     */
    public function getCssClass()
    {
        return $this->getData('css_class');
    }

    /**
     * @return array|string[]
     */
    public function getIdentities()
    {
        return [];
    }
}
