define([
    'jquery',
    'underscore'
], function ($, _) {
    'use strict';
    
    var options = {
        url:    '',
        params: {}
    };
    
    var loader = {
        init: function () {
            
            $.getJSON(options.url, options.params).done(function (response) {
                this.placeBanners(response['banners'])
            }.bind(this)).fail(function (error) {
                console.log(error);
            })
        },
        
        placeBanners: function (data) {
            _.each(data, function (item) {
                var position = item['position'];
                var content = item['content'];
                
                var $placeholder = $('[data-promo-banner-placeholder="' + position + '"]');
                $placeholder.html(content);
            })
        },
        
        'Mirasvit_PromoBanner/js/loader': function (settings) {
            options = _.extend(options, settings);
            
            loader.init();
        }
    };
    
    
    return loader;
});
