<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.7
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Mirasvit\PromoBanner\Api\Data\BannerInterface;

class InstallSchema implements InstallSchemaInterface
{
    /**
     * {@inheritdoc}
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $installer = $setup;

        $installer->startSetup();

        $table = $installer->getConnection()->newTable(
            $installer->getTable(BannerInterface::TABLE_NAME)
        )->addColumn(
            BannerInterface::ID,
            Table::TYPE_INTEGER,
            null,
            ['nullable' => false, 'identity' => true, 'primary' => true],
            BannerInterface::ID
        )->addColumn(
            BannerInterface::NAME,
            Table::TYPE_TEXT,
            255,
            ['nullable' => false],
            BannerInterface::NAME
        )->addColumn(
            BannerInterface::IS_ACTIVE,
            Table::TYPE_INTEGER,
            1,
            ['unsigned' => false, 'nullable' => false, 'default' => 0],
            BannerInterface::IS_ACTIVE
        )->addColumn(
            BannerInterface::ACTIVE_FROM,
            Table::TYPE_DATETIME,
            null,
            ['nullable' => true],
            BannerInterface::ACTIVE_FROM
        )->addColumn(
            BannerInterface::ACTIVE_TO,
            Table::TYPE_DATETIME,
            1,
            ['nullable' => true],
            BannerInterface::ACTIVE_TO
        )->addColumn(
            BannerInterface::POSITIONS,
            Table::TYPE_TEXT,
            255,
            ['nullable' => false],
            BannerInterface::POSITIONS
        )->addColumn(
            BannerInterface::SORT_ORDER,
            Table::TYPE_INTEGER,
            11,
            ['nullable' => false, 'default' => 0],
            BannerInterface::SORT_ORDER
        )->addColumn(
            BannerInterface::CONTENT,
            Table::TYPE_TEXT,
            16777217,
            ['nullable' => true],
            BannerInterface::CONTENT
        )->addColumn(
            BannerInterface::CONDITIONS_SERIALIZED,
            Table::TYPE_TEXT,
            16777217,
            ['nullable' => true],
            BannerInterface::CONDITIONS_SERIALIZED
        )->addColumn(
            BannerInterface::CUSTOMER_GROUP_IDS,
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            BannerInterface::CUSTOMER_GROUP_IDS
        )->addColumn(
            BannerInterface::STORE_IDS,
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            BannerInterface::STORE_IDS
        )->addColumn(
            BannerInterface::SALES_RULE_IDS,
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            BannerInterface::SALES_RULE_IDS
        )->addColumn(
            BannerInterface::CATALOG_RULE_IDS,
            Table::TYPE_TEXT,
            255,
            ['nullable' => true],
            BannerInterface::CATALOG_RULE_IDS
        );
        $installer->getConnection()->createTable($table);
    }
}
