<?php
/**
 * Mirasvit
 *
 * This source file is subject to the Mirasvit Software License, which is available at https://mirasvit.com/license/.
 * Do not edit or add to this file if you wish to upgrade the to newer versions in the future.
 * If you wish to customize this module for your needs.
 * Please refer to http://www.magentocommerce.com for more information.
 *
 * @category  Mirasvit
 * @package   mirasvit/module-sales-rule
 * @version   1.0.7
 * @copyright Copyright (C) 2019 Mirasvit (https://mirasvit.com/)
 */



namespace Mirasvit\PromoBanner\Model\Config\Source;

use Magento\Customer\Model\Config\Source\Group;
use Magento\Framework\Data\OptionSourceInterface;

class CustomerGroup implements OptionSourceInterface
{
    private $group;


    public function __construct(
        Group $group
    ) {
        $this->group = $group;
    }

    public function toOptionArray()
    {
        $result = [
            [
                'label' => 'NOT LOGGED IN',
                'value' => 0,
            ],
        ];

        foreach ($this->group->toOptionArray() as $item) {
            $result[] = $item;
        }

        return $result;
    }
}